/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect.os.json.jackson;

import jakarta.json.stream.JsonGenerator;
import org.opensearch.client.json.jackson.JacksonJsonpGenerator;

public final class SearchAfterFieldJsonGenerator
extends JacksonJsonpGenerator {
    private static final String MIN_LONG_AS_STRING = String.format("%d", Long.MIN_VALUE);
    private static final String SEARCH_AFTER_FIELD = "search_after";
    private final JacksonJsonpGenerator generator;
    private boolean writesSearchAfter;

    public SearchAfterFieldJsonGenerator(JacksonJsonpGenerator generator) {
        super(generator.jacksonGenerator());
        this.generator = generator;
    }

    public JsonGenerator writeKey(String name) {
        if (SEARCH_AFTER_FIELD.equals(name)) {
            this.writesSearchAfter = true;
        }
        this.generator.writeKey(name);
        return this;
    }

    public JsonGenerator writeEnd() {
        if (this.writesSearchAfter) {
            this.writesSearchAfter = false;
            return this.generator.writeEnd();
        }
        this.generator.writeEnd();
        return this;
    }

    public JsonGenerator write(String value) {
        if (this.writesSearchAfter && MIN_LONG_AS_STRING.equals(value)) {
            this.generator.write(Long.MIN_VALUE);
        } else {
            this.generator.write(value);
        }
        return this;
    }
}

