/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public final class CustomOffsetDateTimeDeserializer
extends JsonDeserializer<OffsetDateTime> {
    private static final DateTimeFormatter OFFSET_DATE_TIME_FORMATTER_NO_COLON = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXXX");
    private final DateTimeFormatter formatter;

    public CustomOffsetDateTimeDeserializer(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public OffsetDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        OffsetDateTime parsedDate;
        try {
            parsedDate = OffsetDateTime.parse(parser.getText(), this.formatter);
        }
        catch (DateTimeParseException dtpe1) {
            try {
                parsedDate = OffsetDateTime.parse(parser.getText());
            }
            catch (DateTimeParseException dtpe2) {
                try {
                    parsedDate = OffsetDateTime.parse(parser.getText(), OFFSET_DATE_TIME_FORMATTER_NO_COLON);
                }
                catch (DateTimeParseException dtpe3) {
                    parsedDate = ZonedDateTime.parse(parser.getText(), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss").withZone(ZoneId.systemDefault())).toOffsetDateTime();
                }
            }
        }
        return parsedDate;
    }
}

