/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect.es;

import co.elastic.clients.elasticsearch.ElasticsearchAsyncClient;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.search.connect.SearchClientConnectException;
import io.camunda.search.connect.configuration.ConnectConfiguration;
import io.camunda.search.connect.configuration.SecurityConfiguration;
import io.camunda.search.connect.jackson.JacksonConfiguration;
import io.camunda.search.connect.plugin.PluginRepository;
import io.camunda.search.connect.util.SecurityUtil;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticsearchConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchConnector.class);
    private final ConnectConfiguration configuration;
    private final ObjectMapper objectMapper;
    private final PluginRepository pluginRepository;

    public ElasticsearchConnector(ConnectConfiguration configuration) {
        this(configuration, new JacksonConfiguration(configuration).createObjectMapper(), new PluginRepository());
    }

    public ElasticsearchConnector(ConnectConfiguration configuration, ObjectMapper objectMapper, PluginRepository pluginRepository) {
        this.configuration = configuration;
        this.objectMapper = objectMapper;
        this.pluginRepository = pluginRepository;
    }

    public ElasticsearchClient createClient() {
        LOGGER.debug("Creating Elasticsearch Client ...");
        this.pluginRepository.load(this.configuration.getInterceptorPlugins());
        RestClient restClient = this.createRestClient(this.configuration);
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper(this.objectMapper));
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    public ElasticsearchAsyncClient createAsyncClient() {
        LOGGER.debug("Creating async Elasticsearch Client ...");
        this.pluginRepository.load(this.configuration.getInterceptorPlugins());
        RestClient restClient = this.createRestClient(this.configuration);
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper(this.objectMapper));
        return new ElasticsearchAsyncClient((ElasticsearchTransport)transport);
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    private RestClient createRestClient(ConnectConfiguration configuration) {
        HttpHost httpHost = this.getHttpHost(configuration);
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{httpHost});
        if (configuration.getConnectTimeout() != null || configuration.getSocketTimeout() != null) {
            restClientBuilder.setRequestConfigCallback(configCallback -> this.setTimeouts(configCallback, configuration));
        }
        RestClient restClient = restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> this.configureHttpClient(httpClientBuilder, configuration, this.pluginRepository.asRequestInterceptor())).build();
        return restClient;
    }

    protected HttpAsyncClientBuilder configureHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder, ConnectConfiguration configuration, HttpRequestInterceptor ... interceptors) {
        this.setupAuthentication(httpAsyncClientBuilder, configuration);
        SecurityConfiguration security = configuration.getSecurity();
        if (security != null && security.isEnabled()) {
            this.setupSSLContext(httpAsyncClientBuilder, security);
        }
        for (HttpRequestInterceptor interceptor : interceptors) {
            httpAsyncClientBuilder.addInterceptorLast(interceptor);
        }
        return httpAsyncClientBuilder;
    }

    private void setupSSLContext(HttpAsyncClientBuilder httpAsyncClientBuilder, SecurityConfiguration configuration) {
        try {
            SSLContext sslContext = SecurityUtil.getSSLContext(configuration, "elasticsearch-host");
            httpAsyncClientBuilder.setSSLContext(sslContext);
            if (!configuration.isVerifyHostname()) {
                httpAsyncClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in setting up SSLContext", (Throwable)e);
        }
    }

    private RequestConfig.Builder setTimeouts(RequestConfig.Builder builder, ConnectConfiguration elsConfig) {
        if (elsConfig.getSocketTimeout() != null) {
            builder.setSocketTimeout(elsConfig.getSocketTimeout().intValue());
        }
        if (elsConfig.getConnectTimeout() != null) {
            builder.setConnectTimeout(elsConfig.getConnectTimeout().intValue());
        }
        return builder;
    }

    private HttpHost getHttpHost(ConnectConfiguration elsConfig) {
        try {
            return HttpHost.create((String)elsConfig.getUrl());
        }
        catch (Exception e) {
            throw new SearchClientConnectException("Error in url: " + elsConfig.getUrl(), e);
        }
    }

    private void setupAuthentication(HttpAsyncClientBuilder builder, ConnectConfiguration configuration) {
        String username = configuration.getUsername();
        String password = configuration.getPassword();
        if (username == null || password == null || username.isEmpty() || password.isEmpty()) {
            LOGGER.warn("Username and/or password for are empty. Basic authentication for elasticsearch is not used.");
            return;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }
}

