/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.search.connect.configuration.ConnectConfiguration;
import io.camunda.search.connect.es.ElasticsearchConnector;
import io.camunda.search.connect.os.OpensearchConnector;
import io.camunda.search.es.clients.ElasticsearchSearchClient;
import io.camunda.search.os.clients.OpensearchSearchClient;
import java.util.function.Function;
import org.opensearch.client.opensearch.OpenSearchClient;

public interface SearchClientProvider
extends Function<ConnectConfiguration, CamundaSearchClient> {

    public static final class SearchClientProviders {
        private SearchClientProviders() {
        }

        public static CamundaSearchClient createElasticsearchProvider(ConnectConfiguration configuration) {
            ElasticsearchConnector connector = new ElasticsearchConnector(configuration);
            ElasticsearchClient elasticsearch = connector.createClient();
            return new ElasticsearchSearchClient(elasticsearch);
        }

        public static CamundaSearchClient createOpensearchProvider(ConnectConfiguration configuration) {
            OpensearchConnector connector = new OpensearchConnector(configuration);
            OpenSearchClient opensearch = connector.createClient();
            return new OpensearchSearchClient(opensearch);
        }
    }
}

