/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.management.api.client.properties;

import java.util.Map;
import java.util.Properties;

public record CamundaManagementApiClientProperties(String baseUrl, String clientId, String clientSecret, String oAuthUrl, String oAuthAudience) {
    public static CamundaManagementApiClientProperties fromEnv() {
        return CamundaManagementApiClientProperties.fromEnv(System.getenv());
    }

    public static CamundaManagementApiClientProperties fromEnv(Map<String, String> environment) {
        return new CamundaManagementApiClientProperties(environment.getOrDefault("CAMUNDA_MANAGEMENT_API_BASE_URL", "https://api.cloud.camunda.io"), environment.get("CAMUNDA_MANAGEMENT_API_CLIENT_ID"), environment.get("CAMUNDA_MANAGEMENT_API_CLIENT_SECRET"), environment.getOrDefault("CAMUNDA_OAUTH_URL", "https://login.cloud.camunda.io/oauth/token"), environment.getOrDefault("CAMUNDA_MANAGEMENT_API_OAUTH_AUDIENCE", "api.cloud.camunda.io"));
    }

    public static CamundaManagementApiClientProperties fromProperties(Properties properties) {
        return new CamundaManagementApiClientProperties(properties.getProperty("camunda.management.api.base-url", "https://api.cloud.camunda.io"), properties.getProperty("camunda.management.api.client-id"), properties.getProperty("camunda.management.api.client-secret"), properties.getProperty("camunda.oauth-url", "https://login.cloud.camunda.io/oauth/token"), properties.getProperty("camunda.management.api.oauth-audience", "api.cloud.camunda.io"));
    }
}

