/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.management.api.client.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.camunda.management.api.client.auth.JsonClientResponseHandler;
import io.camunda.management.api.client.properties.CamundaManagementApiClientProperties;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(TokenRequestInterceptor.class);
    private final CamundaManagementApiClientProperties properties;
    private final JsonClientResponseHandler responseHandler;
    private String token;
    private LocalDateTime timeout = LocalDateTime.now();

    public TokenRequestInterceptor(CamundaManagementApiClientProperties properties, JsonClientResponseHandler responseHandler) {
        this.properties = properties;
        this.responseHandler = responseHandler;
    }

    public void process(HttpRequest request, EntityDetails entity, HttpContext context) {
        if (this.timedOut()) {
            LOG.debug("Token is timed out, fetching new token");
            this.getNewToken();
            LOG.debug("Got new token, expires at {}", (Object)this.timeout);
        }
        this.addToken(request);
        LOG.debug("Token added to request");
    }

    private void addToken(HttpRequest request) {
        request.setHeader("Authorization", (Object)("Bearer " + this.token));
    }

    private void getNewToken() {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost request = new HttpPost(URI.create(this.properties.oAuthUrl()));
            StringEntity entity = new StringEntity(this.createRequest(), ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)entity);
            JsonNode response = (JsonNode)httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)this.responseHandler);
            this.token = response.get("access_token").textValue();
            this.timeout = LocalDateTime.now().plusSeconds(response.get("expires_in").asInt());
        }
        catch (IOException e) {
            throw new RuntimeException("Error while fetching token", e);
        }
    }

    private String createRequest() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        node.put("grant_type", "client_credentials");
        node.put("audience", this.properties.oAuthAudience());
        node.put("client_id", this.properties.clientId());
        node.put("client_secret", this.properties.clientSecret());
        return node.toPrettyString();
    }

    private boolean timedOut() {
        return this.timeout.minusSeconds(10L).isBefore(LocalDateTime.now());
    }
}

