/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.management.api.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.management.api.client.api.DefaultApi;
import io.camunda.management.api.client.auth.JsonClientResponseHandler;
import io.camunda.management.api.client.auth.TokenRequestInterceptor;
import io.camunda.management.api.client.invoker.ApiClient;
import io.camunda.management.api.client.properties.CamundaManagementApiClientProperties;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.HttpRequestInterceptor;

public class DefaultApiFactory {
    private final CamundaManagementApiClientProperties properties;
    private final ObjectMapper objectMapper;
    private DefaultApi api;

    private DefaultApiFactory(CamundaManagementApiClientProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
    }

    public static DefaultApiFactory getInstance(CamundaManagementApiClientProperties properties) {
        return DefaultApiFactory.getInstance(properties, new ObjectMapper());
    }

    public static DefaultApiFactory getInstance(CamundaManagementApiClientProperties properties, ObjectMapper objectMapper) {
        return new DefaultApiFactory(properties, objectMapper);
    }

    public DefaultApi get() {
        this.ensureApiClient();
        return this.api;
    }

    private void ensureApiClient() {
        if (this.api == null) {
            TokenRequestInterceptor interceptor = new TokenRequestInterceptor(this.properties, new JsonClientResponseHandler(this.objectMapper));
            CloseableHttpClient httpClient = HttpClients.custom().addRequestInterceptorFirst((HttpRequestInterceptor)interceptor).build();
            ApiClient apiClient = new ApiClient(httpClient);
            apiClient.setBasePath(this.properties.baseUrl());
            this.api = new DefaultApi(apiClient);
        }
    }
}

