/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.AtomixClusterBuilder;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.SwimMembershipProtocol;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.gateway.Gateway;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.SpringGatewayBridge;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.camunda.zeebe.gateway.impl.configuration.ClusterCfg;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.configuration.MembershipCfg;
import io.camunda.zeebe.gateway.impl.configuration.SecurityCfg;
import io.camunda.zeebe.shared.ActorClockConfiguration;
import io.camunda.zeebe.shared.Profile;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.VersionUtil;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

@SpringBootApplication(scanBasePackages={"io.camunda.zeebe.gateway", "io.camunda.zeebe.shared", "io.camunda.zeebe.util.liveness"})
@ConfigurationPropertiesScan(basePackages={"io.camunda.zeebe.gateway", "io.camunda.zeebe.shared"})
public class StandaloneGateway
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent>,
CloseableSilently {
    private static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private final GatewayCfg configuration;
    private final SpringGatewayBridge springGatewayBridge;
    private final ActorClockConfiguration clockConfig;
    private AtomixCluster atomixCluster;
    private Gateway gateway;
    private ActorScheduler actorScheduler;

    @Autowired
    public StandaloneGateway(GatewayCfg configuration, SpringGatewayBridge springGatewayBridge, ActorClockConfiguration clockConfig) {
        this.configuration = configuration;
        this.springGatewayBridge = springGatewayBridge;
        this.clockConfig = clockConfig;
    }

    public static void main(String[] args) {
        System.setProperty("spring.banner.location", "classpath:/assets/zeebe_gateway_banner.txt");
        SpringApplication application = new SpringApplicationBuilder(new Class[]{StandaloneGateway.class}).web(WebApplicationType.SERVLET).logStartupInfo(true).profiles(new String[]{Profile.GATEWAY.getId()}).build(args);
        application.run(new String[0]);
    }

    public void run(String ... args) throws Exception {
        this.configuration.init();
        if (LOG.isInfoEnabled()) {
            LOG.info("Version: {}", (Object)VersionUtil.getVersion());
            LOG.info("Starting standalone gateway with configuration {}", (Object)this.configuration.toJson());
        }
        this.atomixCluster = this.createAtomixCluster(this.configuration.getCluster());
        this.actorScheduler = this.createActorScheduler(this.configuration);
        this.gateway = new Gateway(this.configuration, this::createBrokerClient, (ActorSchedulingService)this.actorScheduler);
        this.springGatewayBridge.registerGatewayStatusSupplier(() -> ((Gateway)this.gateway).getStatus());
        this.springGatewayBridge.registerClusterStateSupplier(() -> Optional.ofNullable(this.gateway.getBrokerClient()).map(BrokerClient::getTopologyManager).map(BrokerTopologyManager::getTopology));
        this.actorScheduler.start();
        this.atomixCluster.start();
        this.gateway.start();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.close();
    }

    public void close() {
        if (this.gateway != null) {
            try {
                this.gateway.stop();
            }
            catch (Exception e) {
                LOG.warn("Failed to gracefully shutdown gRPC gateway", (Throwable)e);
            }
        }
        if (this.atomixCluster != null) {
            try {
                this.atomixCluster.stop().orTimeout(10L, TimeUnit.SECONDS).join();
            }
            catch (Exception e) {
                LOG.warn("Failed to gracefully shutdown cluster services", (Throwable)e);
            }
        }
        if (this.actorScheduler != null) {
            try {
                this.actorScheduler.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to gracefully shutdown actor scheduler", (Throwable)e);
            }
        }
        LogManager.shutdown();
    }

    private BrokerClient createBrokerClient(GatewayCfg config) {
        return new BrokerClientImpl(config, this.atomixCluster.getMessagingService(), this.atomixCluster.getMembershipService(), this.atomixCluster.getEventService(), this.actorScheduler, false);
    }

    private AtomixCluster createAtomixCluster(ClusterCfg config) {
        GroupMembershipProtocol membershipProtocol = this.createMembershipProtocol(config.getMembership());
        AtomixClusterBuilder builder = AtomixCluster.builder().withMemberId(config.getMemberId()).withAddress(Address.from((String)config.getHost(), (int)config.getPort())).withClusterId(config.getClusterName()).withMembershipProvider(BootstrapDiscoveryProvider.builder().withNodes(new Address[]{Address.from((String)config.getContactPoint())}).build()).withMembershipProtocol(membershipProtocol);
        if (config.getSecurity().isEnabled()) {
            this.applyClusterSecurityConfig(config, builder);
        }
        return builder.build();
    }

    private GroupMembershipProtocol createMembershipProtocol(MembershipCfg config) {
        return SwimMembershipProtocol.builder().withFailureTimeout(config.getFailureTimeout()).withGossipInterval(config.getGossipInterval()).withProbeInterval(config.getProbeInterval()).withProbeTimeout(config.getProbeTimeout()).withBroadcastDisputes(config.isBroadcastDisputes()).withBroadcastUpdates(config.isBroadcastUpdates()).withGossipFanout(config.getGossipFanout()).withNotifySuspect(config.isNotifySuspect()).withSuspectProbes(config.getSuspectProbes()).withSyncInterval(config.getSyncInterval()).build();
    }

    private ActorScheduler createActorScheduler(GatewayCfg config) {
        return ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(config.getThreads().getManagementThreads()).setIoBoundActorThreadCount(0).setSchedulerName("gateway-scheduler").setActorClock(this.clockConfig.getClock()).build();
    }

    private void applyClusterSecurityConfig(ClusterCfg config, AtomixClusterBuilder builder) {
        SecurityCfg security = config.getSecurity();
        File certificateChainPath = security.getCertificateChainPath();
        File privateKeyPath = security.getPrivateKeyPath();
        if (certificateChainPath == null) {
            throw new IllegalArgumentException("Expected to have a valid certificate chain path for cluster security, but none configured");
        }
        if (privateKeyPath == null) {
            throw new IllegalArgumentException("Expected to have a valid private key path for cluster security, but none was configured");
        }
        if (!certificateChainPath.canRead()) {
            throw new IllegalArgumentException(String.format("Expected the configured cluster security certificate chain path '%s' to point to a readable file, but it does not", certificateChainPath));
        }
        if (!privateKeyPath.canRead()) {
            throw new IllegalArgumentException(String.format("Expected the configured cluster security private key path '%s' to point to a readable file, but it does not", privateKeyPath));
        }
        builder.withSecurity(certificateChainPath, privateKeyPath);
    }
}

