/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.processing;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.KeyGeneratorControls;
import io.camunda.zeebe.engine.state.NextValueManager;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.protocol.Protocol;

public final class DbKeyGenerator
implements KeyGeneratorControls {
    private static final long INITIAL_VALUE = 0L;
    private static final String LATEST_KEY = "latestKey";
    private final long keyStartValue;
    private final NextValueManager nextValueManager;

    public DbKeyGenerator(int partitionId, ZeebeDb zeebeDb, TransactionContext transactionContext) {
        this.keyStartValue = Protocol.encodePartitionId((int)partitionId, (long)0L);
        this.nextValueManager = new NextValueManager(this.keyStartValue, (ZeebeDb<ZbColumnFamilies>)zeebeDb, transactionContext, ZbColumnFamilies.KEY);
    }

    @Override
    public long nextKey() {
        return this.nextValueManager.getNextValue(LATEST_KEY);
    }

    @Override
    public void setKeyIfHigher(long key) {
        long currentKey = this.nextValueManager.getCurrentValue(LATEST_KEY);
        if (key > currentKey) {
            this.nextValueManager.setValue(LATEST_KEY, key);
        }
    }
}

