/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BooleanProperty;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.StringValue;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class EventScopeInstance
extends UnpackedObject
implements DbValue {
    private final BooleanProperty acceptingProp = new BooleanProperty("accepting");
    private final ArrayProperty<StringValue> interruptingProp = new ArrayProperty("interrupting", (BaseValue)new StringValue());

    public EventScopeInstance() {
        this.declareProperty((BaseProperty)this.acceptingProp).declareProperty(this.interruptingProp);
    }

    public EventScopeInstance(EventScopeInstance other) {
        this();
        int length = other.getLength();
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[length]);
        other.write((MutableDirectBuffer)buffer, 0);
        this.wrap((DirectBuffer)buffer, 0, length);
    }

    public boolean isAccepting() {
        return this.acceptingProp.getValue();
    }

    public EventScopeInstance setAccepting(boolean accepting) {
        this.acceptingProp.setValue(accepting);
        return this;
    }

    public EventScopeInstance addInterrupting(DirectBuffer elementId) {
        ((StringValue)this.interruptingProp.add()).wrap(elementId);
        return this;
    }

    public boolean isInterrupting(DirectBuffer elementId) {
        for (StringValue stringValue : this.interruptingProp) {
            if (!stringValue.getValue().equals(elementId)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.acceptingProp, this.interruptingProp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventScopeInstance)) {
            return false;
        }
        EventScopeInstance that = (EventScopeInstance)((Object)o);
        return Objects.equals(this.acceptingProp, that.acceptingProp) && Objects.equals(this.interruptingProp, that.interruptingProp);
    }
}

