/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.TypedStreamWriterProxy;
import io.camunda.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.RecordProcessorMap;
import io.camunda.zeebe.engine.processing.streamprocessor.RecordValues;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorListener;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorMode;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.EventApplyingStateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.NoopTypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriterImpl;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.KeyGeneratorControls;
import io.camunda.zeebe.engine.state.ZeebeDbState;
import io.camunda.zeebe.engine.state.mutable.MutableLastProcessedPositionState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.util.sched.ActorControl;
import java.util.function.BooleanSupplier;

public final class ProcessingContext
implements ReadonlyProcessingContext {
    private static final StreamProcessorListener NOOP_LISTENER = processedCommand -> {};
    private final TypedStreamWriterProxy streamWriterProxy = new TypedStreamWriterProxy();
    private final NoopTypedStreamWriter noopTypedStreamWriter = new NoopTypedStreamWriter();
    private ActorControl actor;
    private LogStream logStream;
    private LogStreamReader logStreamReader;
    private TypedStreamWriter logStreamWriter = this.noopTypedStreamWriter;
    private CommandResponseWriter commandResponseWriter;
    private TypedResponseWriterImpl typedResponseWriter;
    private RecordValues recordValues;
    private RecordProcessorMap recordProcessorMap;
    private ZeebeDbState zeebeState;
    private TransactionContext transactionContext;
    private EventApplier eventApplier;
    private BooleanSupplier abortCondition;
    private StreamProcessorListener streamProcessorListener = NOOP_LISTENER;
    private int maxFragmentSize;
    private StreamProcessorMode streamProcessorMode = StreamProcessorMode.PROCESSING;

    public ProcessingContext() {
        this.streamWriterProxy.wrap(this.logStreamWriter);
    }

    public ProcessingContext actor(ActorControl actor) {
        this.actor = actor;
        return this;
    }

    public ProcessingContext logStream(LogStream logStream) {
        this.logStream = logStream;
        return this;
    }

    public ProcessingContext logStreamReader(LogStreamReader logStreamReader) {
        this.logStreamReader = logStreamReader;
        return this;
    }

    public ProcessingContext eventCache(RecordValues recordValues) {
        this.recordValues = recordValues;
        return this;
    }

    public ProcessingContext recordProcessorMap(RecordProcessorMap recordProcessorMap) {
        this.recordProcessorMap = recordProcessorMap;
        return this;
    }

    public ProcessingContext zeebeState(ZeebeDbState zeebeState) {
        this.zeebeState = zeebeState;
        return this;
    }

    public ProcessingContext transactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
        return this;
    }

    public ProcessingContext abortCondition(BooleanSupplier abortCondition) {
        this.abortCondition = abortCondition;
        return this;
    }

    public ProcessingContext logStreamWriter(TypedStreamWriter logStreamWriter) {
        this.logStreamWriter = logStreamWriter;
        return this;
    }

    public ProcessingContext commandResponseWriter(CommandResponseWriter commandResponseWriter) {
        this.commandResponseWriter = commandResponseWriter;
        this.typedResponseWriter = new TypedResponseWriterImpl(commandResponseWriter, this.getLogStream().getPartitionId());
        return this;
    }

    public CommandResponseWriter getCommandResponseWriter() {
        return this.commandResponseWriter;
    }

    public ProcessingContext listener(StreamProcessorListener streamProcessorListener) {
        this.streamProcessorListener = streamProcessorListener;
        return this;
    }

    public ProcessingContext maxFragmentSize(int maxFragmentSize) {
        this.maxFragmentSize = maxFragmentSize;
        return this;
    }

    public ProcessingContext eventApplier(EventApplier eventApplier) {
        this.eventApplier = eventApplier;
        return this;
    }

    public ProcessingContext processorMode(StreamProcessorMode streamProcessorMode) {
        this.streamProcessorMode = streamProcessorMode;
        return this;
    }

    public KeyGeneratorControls getKeyGeneratorControls() {
        return this.zeebeState.getKeyGeneratorControls();
    }

    public MutableLastProcessedPositionState getLastProcessedPositionState() {
        return this.zeebeState.getLastProcessedPositionState();
    }

    @Override
    public ActorControl getActor() {
        return this.actor;
    }

    @Override
    public LogStream getLogStream() {
        return this.logStream;
    }

    @Override
    public LogStreamReader getLogStreamReader() {
        return this.logStreamReader;
    }

    @Override
    public int getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    @Override
    public TypedStreamWriter getLogStreamWriter() {
        return this.streamWriterProxy;
    }

    @Override
    public Writers getWriters() {
        EventApplyingStateWriter stateWriter = new EventApplyingStateWriter(this.streamWriterProxy, this.eventApplier);
        return new Writers(this.streamWriterProxy, stateWriter, this.typedResponseWriter);
    }

    @Override
    public RecordValues getRecordValues() {
        return this.recordValues;
    }

    @Override
    public RecordProcessorMap getRecordProcessorMap() {
        return this.recordProcessorMap;
    }

    @Override
    public MutableZeebeState getZeebeState() {
        return this.zeebeState;
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public BooleanSupplier getAbortCondition() {
        return this.abortCondition;
    }

    @Override
    public EventApplier getEventApplier() {
        return this.eventApplier;
    }

    public StreamProcessorListener getStreamProcessorListener() {
        return this.streamProcessorListener;
    }

    public void enableLogStreamWriter() {
        this.streamWriterProxy.wrap(this.logStreamWriter);
    }

    public void disableLogStreamWriter() {
        this.streamWriterProxy.wrap(this.noopTypedStreamWriter);
    }

    public StreamProcessorMode getProcessorMode() {
        return this.streamProcessorMode;
    }
}

