/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.processing.message.command.CorrelateProcessMessageSubscriptionDecoder;
import io.camunda.zeebe.engine.processing.message.command.CorrelateProcessMessageSubscriptionEncoder;
import io.camunda.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class CorrelateProcessMessageSubscriptionCommand
extends SbeBufferWriterReader<CorrelateProcessMessageSubscriptionEncoder, CorrelateProcessMessageSubscriptionDecoder> {
    private final CorrelateProcessMessageSubscriptionEncoder encoder = new CorrelateProcessMessageSubscriptionEncoder();
    private final CorrelateProcessMessageSubscriptionDecoder decoder = new CorrelateProcessMessageSubscriptionDecoder();
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer variables = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer bpmnProcessId = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer correlationKey = new UnsafeBuffer(0L, 0);
    private int subscriptionPartitionId;
    private long processInstanceKey;
    private long elementInstanceKey;
    private long messageKey;

    protected CorrelateProcessMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected CorrelateProcessMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void reset() {
        this.subscriptionPartitionId = CorrelateProcessMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.processInstanceKey = CorrelateProcessMessageSubscriptionDecoder.processInstanceKeyNullValue();
        this.elementInstanceKey = CorrelateProcessMessageSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageKey = CorrelateProcessMessageSubscriptionDecoder.messageKeyNullValue();
        this.messageName.wrap(0L, 0);
        this.variables.wrap(0L, 0);
        this.bpmnProcessId.wrap(0L, 0);
        this.correlationKey.wrap(0L, 0);
    }

    public int getLength() {
        return super.getLength() + CorrelateProcessMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity() + CorrelateProcessMessageSubscriptionDecoder.variablesHeaderLength() + this.variables.capacity() + CorrelateProcessMessageSubscriptionDecoder.bpmnProcessIdHeaderLength() + this.bpmnProcessId.capacity() + CorrelateProcessMessageSubscriptionDecoder.correlationKeyHeaderLength() + this.correlationKey.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).processInstanceKey(this.processInstanceKey).elementInstanceKey(this.elementInstanceKey).messageKey(this.messageKey).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity()).putVariables((DirectBuffer)this.variables, 0, this.variables.capacity()).putBpmnProcessId((DirectBuffer)this.bpmnProcessId, 0, this.bpmnProcessId.capacity()).putCorrelationKey((DirectBuffer)this.correlationKey, 0, this.correlationKey.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.processInstanceKey = this.decoder.processInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.messageKey = this.decoder.messageKey();
        offset = this.decoder.limit();
        int messageNameLength = this.decoder.messageNameLength();
        this.messageName.wrap(buffer, offset += CorrelateProcessMessageSubscriptionDecoder.messageNameHeaderLength(), messageNameLength);
        this.decoder.limit(offset += messageNameLength);
        int variablesLength = this.decoder.variablesLength();
        this.variables.wrap(buffer, offset += CorrelateProcessMessageSubscriptionDecoder.variablesHeaderLength(), variablesLength);
        this.decoder.limit(offset += variablesLength);
        int bpmnProcessIdLength = this.decoder.bpmnProcessIdLength();
        this.bpmnProcessId.wrap(buffer, offset += CorrelateProcessMessageSubscriptionDecoder.bpmnProcessIdHeaderLength(), bpmnProcessIdLength);
        this.decoder.limit(offset += bpmnProcessIdLength);
        int correlationKeyLength = this.decoder.correlationKeyLength();
        this.correlationKey.wrap(buffer, offset += CorrelateProcessMessageSubscriptionDecoder.correlationKeyHeaderLength(), correlationKeyLength);
        this.decoder.limit(offset += correlationKeyLength);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public long getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(long messageKey) {
        this.messageKey = messageKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public DirectBuffer getVariables() {
        return this.variables;
    }

    public DirectBuffer getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public DirectBuffer getCorrelationKey() {
        return this.correlationKey;
    }
}

