/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.event;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEndEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.camunda.zeebe.util.EnsureUtil;
import org.agrona.DirectBuffer;

public final class EndEventProcessor
implements BpmnElementProcessor<ExecutableEndEvent> {
    private final NoneEndEventBehavior noneEndEventBehavior = new NoneEndEventBehavior();
    private final ErrorEndEventBehavior errorEndEventBehavior = new ErrorEndEventBehavior();
    private final MessageEndEventBehavior messageEndEventBehavior = new MessageEndEventBehavior();
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnJobBehavior jobBehavior;

    public EndEventProcessor(BpmnBehaviors bpmnBehaviors) {
        this.eventPublicationBehavior = bpmnBehaviors.eventPublicationBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
    }

    @Override
    public Class<ExecutableEndEvent> getType() {
        return ExecutableEndEvent.class;
    }

    @Override
    public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
        this.eventBehaviorOf(element).onActivate(element, activating);
    }

    @Override
    public void onComplete(ExecutableEndEvent element, BpmnElementContext context) {
        this.eventBehaviorOf(element).onComplete(element, context);
    }

    @Override
    public void onTerminate(ExecutableEndEvent element, BpmnElementContext terminating) {
        this.eventBehaviorOf(element).onTerminate(element, terminating);
        this.incidentBehavior.resolveIncidents(terminating);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(terminating);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    private EndEventBehavior eventBehaviorOf(ExecutableEndEvent element) {
        if (element.hasError()) {
            return this.errorEndEventBehavior;
        }
        if (element.getJobWorkerProperties() != null) {
            return this.messageEndEventBehavior;
        }
        return this.noneEndEventBehavior;
    }

    private class NoneEndEventBehavior
    implements EndEventBehavior {
        private NoneEndEventBehavior() {
        }

        @Override
        public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            BpmnElementContext activated = EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating);
            BpmnElementContext completing = EndEventProcessor.this.stateTransitionBehavior.transitionToCompleting(activated);
            EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing).ifLeft(failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, completing));
        }
    }

    private class ErrorEndEventBehavior
    implements EndEventBehavior {
        private ErrorEndEventBehavior() {
        }

        @Override
        public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            ExecutableError error = element.getError();
            EnsureUtil.ensureNotNull((String)"error", (Object)error);
            DirectBuffer errorCode = error.getErrorCode();
            EnsureUtil.ensureNotNullOrEmpty((String)"errorCode", (DirectBuffer)errorCode);
            EndEventProcessor.this.eventPublicationBehavior.findErrorCatchEvent(errorCode, activating).ifRightOrLeft(catchEvent -> {
                EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating);
                EndEventProcessor.this.eventPublicationBehavior.throwErrorEvent((CatchEventAnalyzer.CatchEventTuple)catchEvent);
            }, failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, activating));
        }
    }

    private class MessageEndEventBehavior
    implements EndEventBehavior {
        private MessageEndEventBehavior() {
        }

        @Override
        public void onActivate(ExecutableEndEvent element, BpmnElementContext activating) {
            EndEventProcessor.this.variableMappingBehavior.applyInputMappings(activating, element).flatMap(ok -> EndEventProcessor.this.jobBehavior.createNewJob(activating, element)).ifRightOrLeft(ok -> EndEventProcessor.this.stateTransitionBehavior.transitionToActivated(activating), failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, activating));
        }

        @Override
        public void onComplete(ExecutableEndEvent element, BpmnElementContext completing) {
            EndEventProcessor.this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> EndEventProcessor.this.stateTransitionBehavior.transitionToCompleted(element, completing)).ifRightOrLeft(completed -> EndEventProcessor.this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> EndEventProcessor.this.incidentBehavior.createIncident((Failure)failure, completing));
        }

        @Override
        public void onTerminate(ExecutableEndEvent element, BpmnElementContext terminating) {
            EndEventProcessor.this.jobBehavior.cancelJob(terminating);
        }
    }

    private static interface EndEventBehavior {
        public void onActivate(ExecutableEndEvent var1, BpmnElementContext var2);

        default public void onComplete(ExecutableEndEvent element, BpmnElementContext completing) {
        }

        default public void onTerminate(ExecutableEndEvent element, BpmnElementContext terminating) {
        }
    }
}

