/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing;

import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.ProcessEventProcessors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.deployment.DeploymentCreateProcessor;
import io.camunda.zeebe.engine.processing.deployment.DeploymentResponder;
import io.camunda.zeebe.engine.processing.deployment.distribute.CompleteDeploymentDistributionProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributeProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentRedistributor;
import io.camunda.zeebe.engine.processing.incident.IncidentEventProcessors;
import io.camunda.zeebe.engine.processing.job.JobEventProcessors;
import io.camunda.zeebe.engine.processing.message.MessageEventProcessors;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.migration.DbMigrationController;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.sched.ActorControl;
import java.util.function.Consumer;

public final class EngineProcessors {
    public static TypedRecordProcessors createEngineProcessors(ProcessingContext processingContext, int partitionsCount, SubscriptionCommandSender subscriptionCommandSender, DeploymentDistributor deploymentDistributor, DeploymentResponder deploymentResponder, Consumer<String> onJobsAvailableCallback) {
        ActorControl actor = processingContext.getActor();
        MutableZeebeState zeebeState = processingContext.getZeebeState();
        Writers writers = processingContext.getWriters();
        TypedRecordProcessors typedRecordProcessors = TypedRecordProcessors.processors(zeebeState.getKeyGenerator(), writers);
        typedRecordProcessors.withListener(new DbMigrationController());
        typedRecordProcessors.withListener(processingContext.getZeebeState());
        LogStream stream = processingContext.getLogStream();
        int partitionId = stream.getPartitionId();
        int maxFragmentSize = processingContext.getMaxFragmentSize();
        MutableVariableState variablesState = zeebeState.getVariableState();
        ExpressionProcessor expressionProcessor = new ExpressionProcessor(ExpressionLanguageFactory.createExpressionLanguage(), variablesState::getVariable);
        DueDateTimerChecker timerChecker = new DueDateTimerChecker(zeebeState.getTimerState());
        CatchEventBehavior catchEventBehavior = new CatchEventBehavior(zeebeState, expressionProcessor, subscriptionCommandSender, writers.state(), timerChecker, partitionsCount);
        EventTriggerBehavior eventTriggerBehavior = new EventTriggerBehavior(zeebeState.getKeyGenerator(), catchEventBehavior, writers, zeebeState);
        BpmnEventPublicationBehavior eventPublicationBehavior = new BpmnEventPublicationBehavior(zeebeState, zeebeState.getKeyGenerator(), eventTriggerBehavior, writers);
        EngineProcessors.addDeploymentRelatedProcessorAndServices(catchEventBehavior, partitionId, zeebeState, typedRecordProcessors, deploymentResponder, expressionProcessor, writers, partitionsCount, actor, deploymentDistributor, zeebeState.getKeyGenerator());
        EngineProcessors.addMessageProcessors(eventTriggerBehavior, subscriptionCommandSender, zeebeState, typedRecordProcessors, writers);
        JobMetrics jobMetrics = new JobMetrics(partitionId);
        TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor = EngineProcessors.addProcessProcessors(zeebeState, expressionProcessor, typedRecordProcessors, subscriptionCommandSender, catchEventBehavior, eventTriggerBehavior, writers, timerChecker, jobMetrics);
        JobEventProcessors.addJobProcessors(typedRecordProcessors, zeebeState, onJobsAvailableCallback, eventPublicationBehavior, maxFragmentSize, writers, jobMetrics, eventTriggerBehavior);
        EngineProcessors.addIncidentProcessors(zeebeState, bpmnStreamProcessor, typedRecordProcessors, writers, zeebeState.getKeyGenerator());
        return typedRecordProcessors;
    }

    private static TypedRecordProcessor<ProcessInstanceRecord> addProcessProcessors(MutableZeebeState zeebeState, ExpressionProcessor expressionProcessor, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, CatchEventBehavior catchEventBehavior, EventTriggerBehavior eventTriggerBehavior, Writers writers, DueDateTimerChecker timerChecker, JobMetrics jobMetrics) {
        return ProcessEventProcessors.addProcessProcessors(zeebeState, expressionProcessor, typedRecordProcessors, subscriptionCommandSender, catchEventBehavior, timerChecker, eventTriggerBehavior, writers, jobMetrics);
    }

    private static void addDeploymentRelatedProcessorAndServices(CatchEventBehavior catchEventBehavior, int partitionId, ZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors, DeploymentResponder deploymentResponder, ExpressionProcessor expressionProcessor, Writers writers, int partitionsCount, ActorControl actor, DeploymentDistributor deploymentDistributor, KeyGenerator keyGenerator) {
        DeploymentCreateProcessor processor = new DeploymentCreateProcessor(zeebeState, catchEventBehavior, expressionProcessor, partitionsCount, writers, actor, deploymentDistributor, keyGenerator);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE, processor);
        DeploymentRedistributor deploymentRedistributor = new DeploymentRedistributor(partitionsCount, deploymentDistributor, zeebeState.getDeploymentState());
        typedRecordProcessors.withListener(deploymentRedistributor);
        DeploymentDistributeProcessor deploymentDistributeProcessor = new DeploymentDistributeProcessor(zeebeState.getProcessState(), zeebeState.getMessageStartEventSubscriptionState(), deploymentResponder, partitionId, writers, keyGenerator);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.DISTRIBUTE, deploymentDistributeProcessor);
        CompleteDeploymentDistributionProcessor completeDeploymentDistributionProcessor = new CompleteDeploymentDistributionProcessor(zeebeState.getDeploymentState(), writers);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT_DISTRIBUTION, (Intent)DeploymentDistributionIntent.COMPLETE, completeDeploymentDistributionProcessor);
    }

    private static void addIncidentProcessors(ZeebeState zeebeState, TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor, TypedRecordProcessors typedRecordProcessors, Writers writers, KeyGenerator keyGenerator) {
        IncidentEventProcessors.addProcessors(typedRecordProcessors, zeebeState, bpmnStreamProcessor, writers, keyGenerator);
    }

    private static void addMessageProcessors(EventTriggerBehavior eventTriggerBehavior, SubscriptionCommandSender subscriptionCommandSender, MutableZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors, Writers writers) {
        MessageEventProcessors.addMessageProcessors(eventTriggerBehavior, typedRecordProcessors, zeebeState, subscriptionCommandSender, writers);
    }
}

