/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.probes.liveness;

import io.camunda.zeebe.gateway.impl.probes.health.ClusterAwarenessHealthIndicator;
import io.camunda.zeebe.gateway.impl.probes.liveness.LivenessClusterAwarenessHealthIndicatorProperties;
import io.camunda.zeebe.util.health.DelayedHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration(proxyBeanMethods=false)
@ConditionalOnEnabledHealthIndicator(value="gateway-clusterawareness")
@AutoConfigureBefore(value={HealthContributorAutoConfiguration.class})
@EnableConfigurationProperties(value={LivenessClusterAwarenessHealthIndicatorProperties.class})
@EnableScheduling
public class LivenessClusterAwarenessHealthIndicatorAutoConfiguration {
    @Bean(name={"livenessGatewayClusterAwarenessHealthIndicator"})
    @ConditionalOnMissingBean(name={"livenessGatewayClusterAwarenessHealthIndicator"})
    public HealthIndicator livenessGatewayClusterAwarenessHealthIndicator(ClusterAwarenessHealthIndicator healthIndicator, LivenessClusterAwarenessHealthIndicatorProperties properties) {
        return new DelayedHealthIndicator((HealthIndicator)healthIndicator, properties.getMaxDowntime());
    }
}

