/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker;

import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.cmd.BrokerErrorException;
import io.camunda.zeebe.gateway.cmd.NoTopologyAvailableException;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerResponseConsumer;
import io.camunda.zeebe.gateway.impl.broker.PartitionIdIterator;
import io.camunda.zeebe.gateway.impl.broker.RequestDispatchStrategy;
import io.camunda.zeebe.gateway.impl.broker.RequestRetriesExhaustedException;
import io.camunda.zeebe.gateway.impl.broker.RoundRobinDispatchStrategy;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.camunda.zeebe.protocol.record.ErrorCode;
import java.net.ConnectException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;

public final class RequestRetryHandler {
    private final BrokerClient brokerClient;
    private final RequestDispatchStrategy roundRobinDispatchStrategy;
    private final BrokerTopologyManager topologyManager;

    public RequestRetryHandler(BrokerClient brokerClient, BrokerTopologyManager topologyManager) {
        this.brokerClient = brokerClient;
        this.roundRobinDispatchStrategy = new RoundRobinDispatchStrategy(topologyManager);
        this.topologyManager = topologyManager;
    }

    public <BrokerResponseT> void sendRequest(BrokerRequest<BrokerResponseT> request, BrokerResponseConsumer<BrokerResponseT> responseConsumer, Consumer<Throwable> throwableConsumer) {
        Function<BrokerRequest<BrokerResponseT>, CompletableFuture<BrokerResponse<BrokerResponseT>>> requestSender = this.brokerClient::sendRequest;
        this.sendRequestInternal(request, requestSender, responseConsumer, throwableConsumer);
    }

    public <BrokerResponseT> void sendRequest(BrokerRequest<BrokerResponseT> request, BrokerResponseConsumer<BrokerResponseT> responseConsumer, Consumer<Throwable> throwableConsumer, Duration requestTimeout) {
        Function<BrokerRequest<BrokerResponseT>, CompletableFuture<BrokerResponse<BrokerResponseT>>> requestSender = r -> this.brokerClient.sendRequest(r, requestTimeout);
        this.sendRequestInternal(request, requestSender, responseConsumer, throwableConsumer);
    }

    private <BrokerResponseT> void sendRequestInternal(BrokerRequest<BrokerResponseT> request, Function<BrokerRequest<BrokerResponseT>, CompletableFuture<BrokerResponse<BrokerResponseT>>> requestSender, BrokerResponseConsumer<BrokerResponseT> responseConsumer, Consumer<Throwable> throwableConsumer) {
        BrokerClusterState topology = this.topologyManager.getTopology();
        if (topology == null || topology.getPartitionsCount() == 0) {
            throwableConsumer.accept(new NoTopologyAvailableException());
            return;
        }
        this.sendRequestWithRetry(request, requestSender, this.partitionIdIteratorForType(topology.getPartitionsCount()), responseConsumer, throwableConsumer, new ArrayList<Throwable>());
    }

    private <BrokerResponseT> void sendRequestWithRetry(BrokerRequest<BrokerResponseT> request, Function<BrokerRequest<BrokerResponseT>, CompletableFuture<BrokerResponse<BrokerResponseT>>> requestSender, PartitionIdIterator partitionIdIterator, BrokerResponseConsumer<BrokerResponseT> responseConsumer, Consumer<Throwable> throwableConsumer, Collection<Throwable> errors) {
        if (partitionIdIterator.hasNext()) {
            int partitionId = partitionIdIterator.next();
            request.setPartitionId(partitionId);
            requestSender.apply(request).whenComplete((response, error) -> {
                if (error == null) {
                    responseConsumer.accept(response.getKey(), response.getResponse());
                } else if (this.shouldRetryWithNextPartition((Throwable)error)) {
                    Loggers.GATEWAY_LOGGER.trace("Failed to create process on partition {}", (Object)partitionIdIterator.getCurrentPartitionId(), error);
                    errors.add((Throwable)error);
                    this.sendRequestWithRetry(request, requestSender, partitionIdIterator, responseConsumer, throwableConsumer, errors);
                } else {
                    throwableConsumer.accept((Throwable)error);
                }
            });
        } else {
            RequestRetriesExhaustedException exception = new RequestRetriesExhaustedException();
            errors.forEach(exception::addSuppressed);
            throwableConsumer.accept(exception);
        }
    }

    private boolean shouldRetryWithNextPartition(Throwable error) {
        if (error instanceof ConnectException) {
            return true;
        }
        if (error instanceof BrokerErrorException) {
            ErrorCode code = ((BrokerErrorException)error).getError().getCode();
            return code == ErrorCode.PARTITION_LEADER_MISMATCH || code == ErrorCode.RESOURCE_EXHAUSTED;
        }
        return false;
    }

    private PartitionIdIterator partitionIdIteratorForType(int partitionsCount) {
        int nextPartitionId = this.roundRobinDispatchStrategy.determinePartition();
        return new PartitionIdIterator(nextPartitionId, partitionsCount, this.topologyManager);
    }
}

