/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl;

import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.ErrorResponseDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ErrorResponseHandler {
    protected final ErrorResponseDecoder decoder = new ErrorResponseDecoder();
    protected DirectBuffer errorMessage;

    public boolean handlesResponse(MessageHeaderDecoder responseHeader) {
        return 0 == responseHeader.schemaId() && 10 == responseHeader.templateId();
    }

    public void wrap(DirectBuffer body, int offset, int length, int version) {
        this.decoder.wrap(body, offset, length, version);
        int errorDataLength = this.decoder.errorDataLength();
        byte[] errorData = new byte[errorDataLength];
        this.decoder.getErrorData(errorData, 0, errorDataLength);
        this.errorMessage = BufferUtil.wrapArray((byte[])errorData);
    }

    public ErrorCode getErrorCode() {
        return this.decoder.errorCode();
    }

    public DirectBuffer getErrorMessage() {
        return this.errorMessage;
    }
}

