/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.health.impl;

import io.camunda.zeebe.gateway.health.GatewayHealthManager;
import io.camunda.zeebe.gateway.health.Status;
import io.grpc.BindableService;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.protobuf.services.HealthStatusManager;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class GatewayHealthManagerImpl
implements GatewayHealthManager {
    private static final Set<String> MONITORED_SERVICES = Set.of("gateway_protocol.Gateway", "");
    private final HealthStatusManager statusManager;
    private final AtomicReference<Status> status = new AtomicReference();

    public GatewayHealthManagerImpl() {
        this(new HealthStatusManager());
    }

    public GatewayHealthManagerImpl(HealthStatusManager statusManager) {
        this.statusManager = statusManager;
        this.setStatus(Status.INITIAL);
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public void setStatus(Status status) {
        Status oldStatus = this.status.getAndAccumulate(status, this::computeStatus);
        if (oldStatus != Status.SHUTDOWN && oldStatus != status) {
            this.updateGrpcHealthStatus(status);
        }
    }

    private Status computeStatus(Status currentStatus, Status newStatus) {
        if (currentStatus == Status.SHUTDOWN) {
            return Status.SHUTDOWN;
        }
        return newStatus;
    }

    @Override
    public BindableService getHealthService() {
        return this.statusManager.getHealthService();
    }

    private void updateGrpcHealthStatus(Status status) {
        switch (status) {
            case RUNNING: {
                this.setGrpcHealthStatus(HealthCheckResponse.ServingStatus.SERVING);
                break;
            }
            case SHUTDOWN: {
                this.statusManager.enterTerminalState();
                break;
            }
            default: {
                this.setGrpcHealthStatus(HealthCheckResponse.ServingStatus.NOT_SERVING);
            }
        }
    }

    private void setGrpcHealthStatus(HealthCheckResponse.ServingStatus servingStatus) {
        MONITORED_SERVICES.forEach(service -> this.statusManager.setStatus(service, servingStatus));
    }
}

