/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.cmd;

import io.camunda.zeebe.gateway.cmd.ClientException;

public final class InvalidBrokerRequestArgumentException
extends ClientException {
    private static final String MESSAGE_FORMAT = "Expected argument '%s' to be %s, but was %s";
    private static final long serialVersionUID = -1582037715962211105L;
    private final String argument;
    private final String expectedValue;
    private final String actualValue;

    public InvalidBrokerRequestArgumentException(String argument, String expectedValue, String actualValue) {
        this(argument, expectedValue, actualValue, null);
    }

    public InvalidBrokerRequestArgumentException(String argument, String expectedValue, String actualValue, Throwable cause) {
        super(String.format(MESSAGE_FORMAT, argument, expectedValue, actualValue), cause);
        this.argument = argument;
        this.expectedValue = expectedValue;
        this.actualValue = actualValue;
    }

    public String getArgument() {
        return this.argument;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public String getActualValue() {
        return this.actualValue;
    }
}

