/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.atomix.raft.RaftException;
import io.camunda.zeebe.logstreams.impl.log.LogStorageAppender;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.prometheus.client.Histogram;
import java.util.NoSuchElementException;

public final class Listener
implements LogStorage.AppendListener {
    private final LogStorageAppender appender;
    private final long highestPosition;
    private final Histogram.Timer appendLatencyTimer;
    private final Histogram.Timer commitLatencyTimer;

    public Listener(LogStorageAppender appender, long highestPosition, Histogram.Timer startAppendLatencyTimer, Histogram.Timer startCommitLatencyTimer) {
        this.appender = appender;
        this.highestPosition = highestPosition;
        this.appendLatencyTimer = startAppendLatencyTimer;
        this.commitLatencyTimer = startCommitLatencyTimer;
    }

    @Override
    public void onWrite(long address) {
        this.appender.notifyWritePosition(this.highestPosition, this.appendLatencyTimer);
    }

    @Override
    public void onWriteError(Throwable error) {
        if (error instanceof NoSuchElementException || error instanceof RaftException.NoLeader) {
            LogStorageAppender.LOG.debug("Failed to append block with last event position {}. This can happen during a leader change.", (Object)this.highestPosition, (Object)error);
            return;
        }
        LogStorageAppender.LOG.error("Failed to append block with last event position {}.", (Object)this.highestPosition, (Object)error);
        this.appender.runOnFailure(error);
    }

    @Override
    public void onCommit(long address) {
        this.releaseBackPressure();
        this.appender.notifyCommitPosition(this.highestPosition, this.commitLatencyTimer);
    }

    @Override
    public void onCommitError(long address, Throwable error) {
        LogStorageAppender.LOG.error("Failed to commit block with last event position {}.", (Object)this.highestPosition, (Object)error);
        this.releaseBackPressure();
        this.appender.runOnFailure(error);
    }

    private void releaseBackPressure() {
        this.appender.releaseBackPressure(this.highestPosition);
    }
}

