/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log.entry;

import com.google.common.base.MoreObjects;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.raft.storage.log.entry.InitialEntry;
import io.atomix.raft.storage.log.entry.RaftEntry;
import java.util.Objects;

public class RaftLogEntry {
    private final long term;
    private final RaftEntry entry;

    public RaftLogEntry(long term, RaftEntry entry) {
        this.term = term;
        this.entry = entry;
    }

    public RaftEntry entry() {
        return this.entry;
    }

    public boolean isApplicationEntry() {
        return this.entry instanceof ApplicationEntry;
    }

    public ApplicationEntry getApplicationEntry() {
        return (ApplicationEntry)this.entry;
    }

    public boolean isConfigurationEntry() {
        return this.entry instanceof ConfigurationEntry;
    }

    public ConfigurationEntry getConfigurationEntry() {
        return (ConfigurationEntry)this.entry;
    }

    public boolean isInitialEntry() {
        return this.entry instanceof InitialEntry;
    }

    public InitialEntry getInitialEntry() {
        return (InitialEntry)this.entry;
    }

    public long term() {
        return this.term;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("entry", (Object)this.entry).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaftLogEntry that = (RaftLogEntry)o;
        return this.term == that.term && Objects.equals(this.entry, that.entry);
    }

    public int hashCode() {
        return Objects.hash(this.term, this.entry);
    }
}

