/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftMetrics;
import io.prometheus.client.Gauge;

public class SnapshotReplicationMetrics
extends RaftMetrics {
    private static final String NAMESPACE = "atomix";
    private static final String PARTITION_GROUP_NAME_LABEL = "partitionGroupName";
    private static final String PARTITION_LABEL = "partition";
    private static final Gauge COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).labelNames(new String[]{"partitionGroupName", "partition"})).help("Count of ongoing snapshot replication")).name("snapshot_replication_count")).register();
    private static final Gauge DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).labelNames(new String[]{"partitionGroupName", "partition"})).help("Approximate duration of replication in milliseconds")).name("snapshot_replication_duration_milliseconds")).register();

    public SnapshotReplicationMetrics(String partitionName) {
        super(partitionName);
    }

    public void incrementCount() {
        ((Gauge.Child)COUNT.labels(new String[]{this.partitionGroupName, this.partition})).inc();
    }

    public void decrementCount() {
        ((Gauge.Child)COUNT.labels(new String[]{this.partitionGroupName, this.partition})).dec();
    }

    public void setCount(int value) {
        ((Gauge.Child)COUNT.labels(new String[]{this.partitionGroupName, this.partition})).set((double)value);
    }

    public void observeDuration(long durationMillis) {
        ((Gauge.Child)DURATION.labels(new String[]{this.partitionGroupName, this.partition})).set((double)durationMillis);
    }
}

