/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.protocol;

import com.esotericsoftware.kryo.Serializer;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.NodeDiscoveryEvent;
import io.atomix.cluster.discovery.NodeDiscoveryEventListener;
import io.atomix.cluster.discovery.NodeDiscoveryService;
import io.atomix.cluster.impl.AddressSerializer;
import io.atomix.cluster.protocol.GroupMembershipEvent;
import io.atomix.cluster.protocol.GroupMembershipEventListener;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.SwimMembershipProtocolBuilder;
import io.atomix.cluster.protocol.SwimMembershipProtocolConfig;
import io.atomix.utils.Version;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.event.AbstractListenerManager;
import io.atomix.utils.event.Event;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwimMembershipProtocol
extends AbstractListenerManager<GroupMembershipEvent, GroupMembershipEventListener>
implements GroupMembershipProtocol {
    public static final Type TYPE = new Type();
    private static final Logger LOGGER = LoggerFactory.getLogger(SwimMembershipProtocol.class);
    private static final String MEMBERSHIP_SYNC = "atomix-membership-sync";
    private static final String MEMBERSHIP_GOSSIP = "atomix-membership-gossip";
    private static final String MEMBERSHIP_PROBE = "atomix-membership-probe";
    private static final String MEMBERSHIP_PROBE_REQUEST = "atomix-membership-probe-request";
    private static final io.atomix.utils.serializer.Serializer SERIALIZER = io.atomix.utils.serializer.Serializer.using((Namespace)new Namespace.Builder().register(Namespaces.BASIC).nextId(500).register(new Class[]{MemberId.class}).register((Serializer)new AddressSerializer(), new Class[]{Address.class}).register(new Class[]{ImmutableMember.class}).register(new Class[]{State.class}).register(new Class[]{ImmutablePair.class}).name("ClusterMembershipService").build());
    private final SwimMembershipProtocolConfig config;
    private final AtomicBoolean started = new AtomicBoolean();
    private final Map<MemberId, SwimMember> members = Maps.newConcurrentMap();
    private final List<SwimMember> randomMembers = Lists.newCopyOnWriteArrayList();
    private final Map<MemberId, ImmutableMember> updates = new LinkedHashMap<MemberId, ImmutableMember>();
    private final List<SwimMember> syncMembers = new ArrayList<SwimMember>();
    private final ScheduledExecutorService swimScheduler = Executors.newSingleThreadScheduledExecutor(Threads.namedThreads((String)"atomix-cluster-heartbeat-sender", (Logger)LOGGER));
    private final ExecutorService eventExecutor = Executors.newSingleThreadExecutor(Threads.namedThreads((String)"atomix-cluster-events", (Logger)LOGGER));
    private final AtomicInteger probeCounter = new AtomicInteger();
    private NodeDiscoveryService discoveryService;
    private BootstrapService bootstrapService;
    private SwimMember localMember;
    private final BiFunction<Address, byte[], CompletableFuture<byte[]>> probeRequestHandler = (address, payload) -> this.handleProbeRequest((ImmutableMember)SERIALIZER.decode(payload)).thenApply(arg_0 -> ((io.atomix.utils.serializer.Serializer)SERIALIZER).encode(arg_0));
    private final NodeDiscoveryEventListener discoveryEventListener = this::handleDiscoveryEvent;
    private final BiFunction<Address, byte[], byte[]> syncHandler = (address, payload) -> SERIALIZER.encode(this.handleSync((ImmutableMember)SERIALIZER.decode(payload)));
    private final BiFunction<Address, byte[], byte[]> probeHandler = (address, payload) -> SERIALIZER.encode((Object)this.handleProbe((Pair<ImmutableMember, ImmutableMember>)((Pair)SERIALIZER.decode(payload))));
    private final BiConsumer<Address, byte[]> gossipListener = (address, payload) -> this.handleGossipUpdates((Collection)SERIALIZER.decode(payload));
    private volatile Properties localProperties = new Properties();
    private ScheduledFuture<?> gossipFuture;
    private ScheduledFuture<?> probeFuture;
    private ScheduledFuture<?> syncFuture;

    SwimMembershipProtocol(SwimMembershipProtocolConfig config) {
        this.config = config;
    }

    public static SwimMembershipProtocolBuilder builder() {
        return new SwimMembershipProtocolBuilder();
    }

    public SwimMembershipProtocolConfig config() {
        return this.config;
    }

    @Override
    public Set<Member> getMembers() {
        return ImmutableSet.copyOf(this.members.values());
    }

    @Override
    public Member getMember(MemberId memberId) {
        return this.members.get(memberId);
    }

    @Override
    public CompletableFuture<Void> join(BootstrapService bootstrap, NodeDiscoveryService discovery, Member member) {
        if (this.started.compareAndSet(false, true)) {
            this.bootstrapService = bootstrap;
            this.discoveryService = discovery;
            this.localMember = new SwimMember(member.id(), member.address(), member.zone(), member.rack(), member.host(), member.properties(), member.version(), System.currentTimeMillis());
            this.localProperties.putAll((Map<?, ?>)this.localMember.properties());
            this.discoveryService.addListener(this.discoveryEventListener);
            this.localMember.setState(State.ALIVE);
            this.members.put(this.localMember.id(), this.localMember);
            this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.MEMBER_ADDED, this.localMember));
            LOGGER.debug("Nodes from discovery service {}", this.discoveryService.getNodes());
            this.registerHandlers();
            this.scheduleGossip();
            this.scheduleProbe();
            this.scheduleSync();
            LOGGER.info("Started");
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> leave(Member member) {
        if (this.started.compareAndSet(true, false)) {
            this.discoveryService.removeListener(this.discoveryEventListener);
            this.gossipFuture.cancel(false);
            this.probeFuture.cancel(false);
            this.syncFuture.cancel(false);
            this.swimScheduler.shutdownNow();
            this.eventExecutor.shutdownNow();
            LOGGER.info("{} - Member deactivated: {}", (Object)this.localMember.id(), (Object)this.localMember);
            this.localMember.setState(State.DEAD);
            this.members.clear();
            this.unregisterHandlers();
            LOGGER.info("Stopped");
        }
        return CompletableFuture.completedFuture(null);
    }

    protected void post(GroupMembershipEvent event) {
        this.eventExecutor.execute(() -> super.post((Event)event));
    }

    private void checkMetadata() {
        if (!this.localMember.properties().equals(this.localProperties)) {
            this.localProperties = new Properties();
            this.localProperties.putAll((Map<?, ?>)this.localMember.properties());
            LOGGER.debug("{} - Detected local properties change {}", (Object)this.localMember.id(), (Object)this.localProperties);
            this.localMember.setIncarnationNumber(this.localMember.getIncarnationNumber() + 1L);
            this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.METADATA_CHANGED, this.localMember));
            this.recordUpdate(this.localMember.copy());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean updateState(ImmutableMember member) {
        if (member.id().equals(this.localMember.id())) {
            return false;
        }
        SwimMember swimMember = this.members.get(member.id());
        if (swimMember == null) {
            LOGGER.trace("Member not exist yet {}", (Object)member);
            if (member.state() != State.ALIVE) return false;
            swimMember = new SwimMember(member);
            this.members.put(swimMember.id(), swimMember);
            this.randomMembers.add(swimMember);
            Collections.shuffle(this.randomMembers);
            LOGGER.debug("{} - Member added {}", (Object)this.localMember.id(), (Object)swimMember);
            swimMember.setState(State.ALIVE);
            this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.MEMBER_ADDED, swimMember.copy()));
            this.recordUpdate(swimMember.copy());
            return true;
        }
        if (member.incarnationNumber() > swimMember.getIncarnationNumber()) {
            if (!Objects.equals(member.version(), swimMember.version())) {
                this.members.remove(member.id());
                this.randomMembers.remove(swimMember);
                this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.MEMBER_REMOVED, swimMember.copy()));
                swimMember = new SwimMember(member);
                swimMember.setState(State.ALIVE);
                this.members.put(member.id(), swimMember);
                this.randomMembers.add(swimMember);
                Collections.shuffle(this.randomMembers);
                LOGGER.debug("{} - Evicted member for new version {}", (Object)this.localMember.id(), (Object)swimMember);
                this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.MEMBER_ADDED, swimMember.copy()));
                this.recordUpdate(swimMember.copy());
                return false;
            }
            swimMember.setIncarnationNumber(member.incarnationNumber());
            if (member.state() == State.ALIVE && swimMember.getState() != State.ALIVE) {
                this.triggerReachabilityChangedEventOnAlive(member, swimMember);
            } else if (member.state() == State.SUSPECT && swimMember.getState() != State.SUSPECT) {
                this.triggerReachibilityEventOnSuspect(member, swimMember);
            } else if (member.state() == State.DEAD && swimMember.getState() != State.DEAD) {
                this.triggerReachabilityEventOnDeath(swimMember);
            } else if (!Objects.equals(member.properties(), swimMember.properties())) {
                swimMember.properties().putAll((Map<?, ?>)member.properties());
                LOGGER.debug("{} - Member metadata changed {}", (Object)this.localMember.id(), (Object)swimMember);
                this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.METADATA_CHANGED, swimMember.copy()));
            }
            this.recordUpdate(swimMember.copy());
            return true;
        }
        if (member.incarnationNumber() != swimMember.getIncarnationNumber()) return false;
        if (member.state().ordinal() <= swimMember.getState().ordinal()) return false;
        swimMember.setState(member.state());
        if (member.state() == State.SUSPECT) {
            LOGGER.debug("{} - Member unreachable {}", (Object)this.localMember.id(), (Object)swimMember);
            this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.REACHABILITY_CHANGED, swimMember.copy()));
            if (this.config.isNotifySuspect()) {
                this.gossip(swimMember, Lists.newArrayList((Object[])new ImmutableMember[]{swimMember.copy()}));
            }
        } else if (member.state() == State.DEAD) {
            this.tryRemoveMember(swimMember);
        }
        this.recordUpdate(swimMember.copy());
        return true;
    }

    private void triggerReachabilityEventOnDeath(SwimMember swimMember) {
        if (swimMember.getState() == State.ALIVE) {
            swimMember.setState(State.SUSPECT);
            LOGGER.debug("{} - Member unreachable {}", (Object)this.localMember.id(), (Object)swimMember);
            this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.REACHABILITY_CHANGED, swimMember.copy()));
        }
        swimMember.setState(State.DEAD);
        this.tryRemoveMember(swimMember);
    }

    private void triggerReachibilityEventOnSuspect(ImmutableMember member, SwimMember swimMember) {
        if (!Objects.equals(member.properties(), swimMember.properties())) {
            swimMember.properties().putAll((Map<?, ?>)member.properties());
            LOGGER.debug("{} - Member metadata changed {}", (Object)this.localMember.id(), (Object)swimMember);
            this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.METADATA_CHANGED, swimMember.copy()));
        }
        swimMember.setState(State.SUSPECT);
        LOGGER.debug("{} - Member unreachable {}", (Object)this.localMember.id(), (Object)swimMember);
        this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.REACHABILITY_CHANGED, swimMember.copy()));
        if (this.config.isNotifySuspect()) {
            this.gossip(swimMember, Lists.newArrayList((Object[])new ImmutableMember[]{swimMember.copy()}));
        }
    }

    private void triggerReachabilityChangedEventOnAlive(ImmutableMember member, SwimMember swimMember) {
        swimMember.setState(State.ALIVE);
        LOGGER.debug("{} - Member reachable {}", (Object)this.localMember.id(), (Object)swimMember);
        this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.REACHABILITY_CHANGED, swimMember.copy()));
        if (!Objects.equals(member.properties(), swimMember.properties())) {
            swimMember.properties().putAll((Map<?, ?>)member.properties());
            LOGGER.debug("{} - Member metadata changed {}", (Object)this.localMember.id(), (Object)swimMember);
            this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.METADATA_CHANGED, swimMember.copy()));
        }
    }

    private void recordUpdate(ImmutableMember member) {
        this.updates.put(member.id(), member);
    }

    private void checkFailures() {
        for (SwimMember member : this.members.values()) {
            if (member.getState() != State.SUSPECT || System.currentTimeMillis() - member.getUpdated() <= this.config.getFailureTimeout().toMillis()) continue;
            member.setState(State.DEAD);
            this.tryRemoveMember(member);
            this.recordUpdate(member.copy());
        }
    }

    private void tryRemoveMember(SwimMember member) {
        SwimMember deadMember = this.members.remove(member.id());
        if (deadMember != null) {
            this.randomMembers.remove(member);
            Collections.shuffle(this.randomMembers);
            LOGGER.debug("{} - Member removed {}", (Object)this.localMember.id(), (Object)member);
            this.post(new GroupMembershipEvent(GroupMembershipEvent.Type.MEMBER_REMOVED, member.copy()));
        }
    }

    private void sync(ImmutableMember member) {
        LOGGER.debug("{} - Start synchronizing membership with {}", (Object)this.localMember.id(), (Object)member);
        this.bootstrapService.getMessagingService().sendAndReceive(member.address(), MEMBERSHIP_SYNC, SERIALIZER.encode((Object)this.localMember.copy()), false, this.config.getProbeTimeout()).whenCompleteAsync((response, error) -> {
            if (error == null) {
                Collection members = (Collection)SERIALIZER.decode(response);
                LOGGER.debug("{} - Finished synchronizing membership with {}, received: '{}'", new Object[]{this.localMember.id(), member, members});
                members.forEach(this::updateState);
            } else {
                LOGGER.debug("{} - Failed to synchronize membership with {}", new Object[]{this.localMember.id(), member, error});
            }
            this.scheduleSync();
        }, (Executor)this.swimScheduler);
    }

    private void sync() {
        if (this.syncMembers.isEmpty()) {
            this.syncMembers.addAll(this.members.values());
            this.syncMembers.remove(this.localMember);
            Collections.shuffle(this.syncMembers);
        }
        if (!this.syncMembers.isEmpty()) {
            SwimMember member = this.syncMembers.remove(0);
            if (member != null) {
                this.sync(member.copy());
            }
        } else {
            this.scheduleSync();
        }
    }

    private Collection<ImmutableMember> handleSync(ImmutableMember member) {
        this.updateState(member);
        return this.members.values().stream().map(SwimMember::copy).collect(Collectors.toList());
    }

    private void probe() {
        List probeMembers = this.discoveryService.getNodes().stream().map(node -> new SwimMember(MemberId.from((String)((Object)node.id().id())), node.address())).filter(member -> !this.members.containsKey(member.id())).filter(member -> !member.id().equals(this.localMember.id())).filter(member -> !member.address().equals((Object)this.localMember.address())).sorted(Comparator.comparing(Member::id)).collect(Collectors.toList());
        probeMembers.addAll(this.randomMembers);
        if (!probeMembers.isEmpty()) {
            LOGGER.trace("Possible members to probe '{}'", probeMembers);
            SwimMember probeMember = (SwimMember)probeMembers.get(Math.abs(this.probeCounter.incrementAndGet() % probeMembers.size()));
            this.probe(probeMember.copy());
        } else {
            this.scheduleProbe();
        }
    }

    private void probe(ImmutableMember member) {
        LOGGER.trace("{} - Probing {}", (Object)this.localMember.id(), (Object)member);
        this.bootstrapService.getMessagingService().sendAndReceive(member.address(), MEMBERSHIP_PROBE, SERIALIZER.encode((Object)Pair.of((Object)this.localMember.copy(), (Object)member)), false, this.config.getProbeTimeout()).whenCompleteAsync((response, error) -> {
            if (error == null) {
                this.updateState((ImmutableMember)SERIALIZER.decode(response));
            } else {
                LOGGER.debug("{} - Failed to probe {}", new Object[]{this.localMember.id(), member, error});
                SwimMember swimMember = this.members.get(member.id());
                if (swimMember != null && swimMember.getIncarnationNumber() == member.incarnationNumber()) {
                    this.requestProbes(swimMember.copy());
                }
            }
            this.scheduleProbe();
        }, (Executor)this.swimScheduler);
    }

    private ImmutableMember handleProbe(Pair<ImmutableMember, ImmutableMember> members) {
        ImmutableMember remoteMember = (ImmutableMember)members.getLeft();
        ImmutableMember localMember = (ImmutableMember)members.getRight();
        LOGGER.trace("{} - Received probe {} from {}", new Object[]{this.localMember.id(), localMember, remoteMember});
        if (localMember.incarnationNumber() > this.localMember.getIncarnationNumber()) {
            this.localMember.setIncarnationNumber(localMember.incarnationNumber() + 1L);
            if (this.config.isBroadcastDisputes()) {
                this.broadcast(this.localMember.copy());
            }
        } else if (localMember.state() == State.SUSPECT) {
            this.localMember.setIncarnationNumber(this.localMember.getIncarnationNumber() + 1L);
            if (this.config.isBroadcastDisputes()) {
                this.broadcast(this.localMember.copy());
            }
        }
        this.updateState(remoteMember);
        return this.localMember.copy();
    }

    private void requestProbes(ImmutableMember suspect) {
        Collection<SwimMember> members = this.selectRandomMembers(this.config.getSuspectProbes() - 1, suspect);
        if (!members.isEmpty()) {
            AtomicInteger counter = new AtomicInteger();
            AtomicBoolean succeeded = new AtomicBoolean();
            for (SwimMember member : members) {
                this.requestProbe(member, suspect).whenCompleteAsync((success, error) -> {
                    int count = counter.incrementAndGet();
                    if (error == null && success.booleanValue()) {
                        succeeded.set(true);
                    } else if (count == members.size() && !succeeded.get()) {
                        this.failProbes(suspect);
                    }
                }, (Executor)this.swimScheduler);
            }
        } else {
            this.failProbes(suspect);
        }
    }

    private void failProbes(ImmutableMember suspect) {
        SwimMember swimMember = new SwimMember(suspect);
        LOGGER.debug("{} - Failed all probes of {}", (Object)this.localMember.id(), (Object)swimMember);
        swimMember.setState(State.SUSPECT);
        if (this.updateState(swimMember.copy()) && this.config.isBroadcastUpdates()) {
            this.broadcast(swimMember.copy());
        }
    }

    private CompletableFuture<Boolean> requestProbe(SwimMember member, ImmutableMember suspect) {
        LOGGER.debug("{} - Requesting probe of {} from {}", new Object[]{this.localMember.id(), suspect, member});
        return ((CompletableFuture)((CompletableFuture)this.bootstrapService.getMessagingService().sendAndReceive(member.address(), MEMBERSHIP_PROBE_REQUEST, SERIALIZER.encode((Object)suspect), false, this.config.getProbeTimeout().multipliedBy(2L)).thenApply(arg_0 -> ((io.atomix.utils.serializer.Serializer)SERIALIZER).decode(arg_0))).exceptionally(e -> false)).thenApply(succeeded -> {
            LOGGER.debug("{} - Probe request of {} from {} {}", new Object[]{this.localMember.id(), suspect, member, succeeded != false ? "succeeded" : "failed"});
            return succeeded;
        });
    }

    private Collection<SwimMember> selectRandomMembers(int count, ImmutableMember exclude) {
        List members = this.members.values().stream().filter(member -> !member.id().equals(this.localMember.id()) && !member.id().equals(exclude.id())).collect(Collectors.toList());
        Collections.shuffle(members);
        return members.subList(0, Math.min(members.size(), count));
    }

    private CompletableFuture<Boolean> handleProbeRequest(ImmutableMember member) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.swimScheduler.execute(() -> {
            LOGGER.trace("{} - Probing {}", (Object)this.localMember.id(), (Object)member);
            this.bootstrapService.getMessagingService().sendAndReceive(member.address(), MEMBERSHIP_PROBE, SERIALIZER.encode((Object)Pair.of((Object)this.localMember.copy(), (Object)member)), false, this.config.getProbeTimeout()).whenCompleteAsync((response, error) -> {
                if (error != null) {
                    LOGGER.debug("{} - Failed to probe {}", (Object)this.localMember.id(), (Object)member);
                    future.complete(false);
                } else {
                    future.complete(true);
                }
            }, (Executor)this.swimScheduler);
        });
        return future;
    }

    private void broadcast(ImmutableMember update) {
        for (SwimMember member : this.members.values()) {
            if (this.localMember.id().equals(member.id())) continue;
            this.unicast(member, update);
        }
    }

    private void unicast(SwimMember member, ImmutableMember update) {
        this.bootstrapService.getUnicastService().unicast(member.address(), MEMBERSHIP_GOSSIP, SERIALIZER.encode((Object)Lists.newArrayList((Object[])new ImmutableMember[]{update})));
    }

    private void gossip() {
        this.checkFailures();
        this.checkMetadata();
        if (!this.updates.isEmpty()) {
            ArrayList updates = Lists.newArrayList(this.updates.values());
            this.updates.clear();
            this.gossip(updates);
        }
        this.scheduleGossip();
    }

    private void gossip(Collection<ImmutableMember> updates) {
        ArrayList members = Lists.newArrayList(this.randomMembers);
        if (!members.isEmpty()) {
            Collections.shuffle(members);
            for (int i = 0; i < Math.min(members.size(), this.config.getGossipFanout()); ++i) {
                this.gossip((SwimMember)members.get(i), updates);
            }
        }
    }

    private void gossip(SwimMember member, Collection<ImmutableMember> updates) {
        LOGGER.trace("{} - Gossipping updates {} to {}", new Object[]{this.localMember.id(), updates, member});
        this.bootstrapService.getUnicastService().unicast(member.address(), MEMBERSHIP_GOSSIP, SERIALIZER.encode(updates));
    }

    private void handleGossipUpdates(Collection<ImmutableMember> updates) {
        for (ImmutableMember update : updates) {
            this.updateState(update);
        }
    }

    private void handleDiscoveryEvent(NodeDiscoveryEvent event) {
        switch ((NodeDiscoveryEvent.Type)event.type()) {
            case JOIN: {
                this.handleJoinEvent((Node)event.subject());
                break;
            }
            case LEAVE: {
                this.handleLeaveEvent((Node)event.subject());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void handleJoinEvent(Node node) {
        SwimMember member = new SwimMember(MemberId.from((String)((Object)node.id().id())), node.address());
        if (!this.members.containsKey(member.id())) {
            this.probe(member.copy());
        }
    }

    private void handleLeaveEvent(Node node) {
        SwimMember member = this.members.get(MemberId.from((String)((Object)node.id().id())));
        if (member != null && !member.isActive()) {
            this.members.remove(member.id());
        }
    }

    private void registerHandlers() {
        this.bootstrapService.getMessagingService().registerHandler(MEMBERSHIP_SYNC, this.syncHandler, (Executor)this.swimScheduler);
        this.bootstrapService.getMessagingService().registerHandler(MEMBERSHIP_PROBE, this.probeHandler, (Executor)this.swimScheduler);
        this.bootstrapService.getMessagingService().registerHandler(MEMBERSHIP_PROBE_REQUEST, this.probeRequestHandler);
        this.bootstrapService.getUnicastService().addListener(MEMBERSHIP_GOSSIP, this.gossipListener, this.swimScheduler);
    }

    private void unregisterHandlers() {
        this.bootstrapService.getMessagingService().unregisterHandler(MEMBERSHIP_SYNC);
        this.bootstrapService.getMessagingService().unregisterHandler(MEMBERSHIP_PROBE);
        this.bootstrapService.getMessagingService().unregisterHandler(MEMBERSHIP_PROBE_REQUEST);
        this.bootstrapService.getUnicastService().removeListener(MEMBERSHIP_GOSSIP, this.gossipListener);
    }

    private void scheduleGossip() {
        this.gossipFuture = this.swimScheduler.schedule(this::gossip, this.config.getGossipInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    private void scheduleSync() {
        this.syncFuture = this.swimScheduler.schedule(this::sync, this.config.getSyncInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    private void scheduleProbe() {
        this.probeFuture = this.swimScheduler.schedule(this::probe, this.config.getProbeInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    static class SwimMember
    extends Member {
        private final Version version;
        private final long timestamp;
        private volatile State state;
        private volatile long incarnationNumber;
        private volatile long updated;

        SwimMember(MemberId id, Address address) {
            super(id, address);
            this.version = null;
            this.timestamp = 0L;
        }

        SwimMember(MemberId id, Address address, String zone, String rack, String host, Properties properties, Version version, long timestamp) {
            super(id, address, zone, rack, host, properties);
            this.version = version;
            this.timestamp = timestamp;
            this.incarnationNumber = System.currentTimeMillis();
        }

        SwimMember(ImmutableMember member) {
            super(member.id(), member.address(), member.zone(), member.rack(), member.host(), member.properties());
            this.version = member.version;
            this.timestamp = member.timestamp;
            this.state = member.state;
            this.incarnationNumber = member.incarnationNumber;
        }

        State getState() {
            return this.state;
        }

        void setState(State state) {
            if (this.state != state) {
                this.state = state;
                this.setUpdated(System.currentTimeMillis());
            }
        }

        @Override
        public boolean isActive() {
            return this.state.isActive();
        }

        @Override
        public boolean isReachable() {
            return this.state.isReachable();
        }

        @Override
        public Version version() {
            return this.version;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        long getIncarnationNumber() {
            return this.incarnationNumber;
        }

        void setIncarnationNumber(long incarnationNumber) {
            this.incarnationNumber = incarnationNumber;
        }

        long getUpdated() {
            return this.updated;
        }

        void setUpdated(long updated) {
            this.updated = updated;
        }

        ImmutableMember copy() {
            return new ImmutableMember(this.id(), this.address(), this.zone(), this.rack(), this.host(), this.properties(), this.version(), this.timestamp(), this.state, this.incarnationNumber);
        }
    }

    static enum State {
        ALIVE(true, true),
        SUSPECT(true, false),
        DEAD(false, false);

        private final boolean active;
        private final boolean reachable;

        private State(boolean active, boolean reachable) {
            this.active = active;
            this.reachable = reachable;
        }

        boolean isActive() {
            return this.active;
        }

        boolean isReachable() {
            return this.reachable;
        }
    }

    static class ImmutableMember
    extends Member {
        private final Version version;
        private final long timestamp;
        private final State state;
        private final long incarnationNumber;

        ImmutableMember(MemberId id, Address address, String zone, String rack, String host, Properties properties, Version version, long timestamp, State state, long incarnationNumber) {
            super(id, address, zone, rack, host, properties);
            this.version = version;
            this.timestamp = timestamp;
            this.state = state;
            this.incarnationNumber = incarnationNumber;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(Member.class).add("id", (Object)this.id()).add("address", (Object)this.address()).add("properties", (Object)this.properties()).add("version", (Object)this.version()).add("timestamp", this.timestamp()).add("state", (Object)this.state()).add("incarnationNumber", this.incarnationNumber()).toString();
        }

        @Override
        public Version version() {
            return this.version;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        State state() {
            return this.state;
        }

        long incarnationNumber() {
            return this.incarnationNumber;
        }
    }

    public static class Type
    implements GroupMembershipProtocol.Type<SwimMembershipProtocolConfig> {
        private static final String NAME = "swim";

        public String name() {
            return NAME;
        }

        @Override
        public GroupMembershipProtocol newProtocol(SwimMembershipProtocolConfig config) {
            return new SwimMembershipProtocol(config);
        }
    }
}

