/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.AbstractMessageEncoder;
import io.atomix.cluster.messaging.impl.ProtocolMessage;
import io.atomix.cluster.messaging.impl.ProtocolReply;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import io.atomix.utils.net.Address;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;

class MessageEncoderV1
extends AbstractMessageEncoder {
    MessageEncoderV1(Address address) {
        super(address);
    }

    @Override
    protected void encodeAddress(ProtocolMessage message, ByteBuf buffer) {
        InetAddress senderIp = this.address.address();
        byte[] senderIpBytes = senderIp.getAddress();
        buffer.writeByte(senderIpBytes.length);
        buffer.writeBytes(senderIpBytes);
        buffer.writeInt(this.address.port());
    }

    @Override
    protected void encodeMessage(ProtocolMessage message, ByteBuf buffer) {
        buffer.writeByte(message.type().id());
        MessageEncoderV1.writeLong(buffer, message.id());
        byte[] payload = message.payload();
        MessageEncoderV1.writeInt(buffer, payload.length);
        buffer.writeBytes(payload);
    }

    @Override
    protected void encodeRequest(ProtocolRequest request, ByteBuf out) {
        MessageEncoderV1.writeString(out, request.subject());
    }

    @Override
    protected void encodeReply(ProtocolReply reply, ByteBuf out) {
        out.writeByte(reply.status().id());
    }
}

