/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import io.camunda.zeebe.protocol.record.AdminRequestDecoder;
import io.camunda.zeebe.protocol.record.AdminRequestType;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class AdminRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 3;
    public static final int TEMPLATE_ID = 40;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 3;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final AdminRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 3;
    }

    public int sbeTemplateId() {
        return 40;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public AdminRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 3);
        return this;
    }

    public AdminRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(3).templateId(40).schemaId(0).version(3);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdId() {
        return 1;
    }

    public static int partitionIdSinceVersion() {
        return 0;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public AdminRequestEncoder partitionId(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int typeId() {
        return 2;
    }

    public static int typeSinceVersion() {
        return 0;
    }

    public static int typeEncodingOffset() {
        return 2;
    }

    public static int typeEncodingLength() {
        return 1;
    }

    public static String typeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public AdminRequestEncoder type(AdminRequestType value) {
        this.buffer.putByte(this.offset + 2, (byte)value.value());
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        AdminRequestDecoder decoder = new AdminRequestDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 3, 3);
        return decoder.appendTo(builder);
    }
}

