/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.steps;

import io.camunda.zeebe.broker.logstreams.AtomixLogCompactor;
import io.camunda.zeebe.broker.logstreams.LogDeletionService;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupStep;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import java.util.List;

public class LogDeletionPartitionStartupStep
implements PartitionStartupStep {
    public String getName() {
        return "LogDeletionService";
    }

    public ActorFuture<PartitionStartupContext> startup(PartitionStartupContext partitionStartupContext) {
        AtomixLogCompactor logCompactor = new AtomixLogCompactor(partitionStartupContext.getRaftPartition().getServer());
        LogDeletionService deletionService = new LogDeletionService(partitionStartupContext.getNodeId(), partitionStartupContext.getPartitionId(), logCompactor, List.of(partitionStartupContext.getConstructableSnapshotStore(), partitionStartupContext.getReceivableSnapshotStore()));
        partitionStartupContext.setLogDeletionService(deletionService);
        CompletableActorFuture startupFuture = new CompletableActorFuture();
        partitionStartupContext.getActorSchedulingService().submitActor((Actor)deletionService).onComplete((arg_0, arg_1) -> LogDeletionPartitionStartupStep.lambda$startup$0((ActorFuture)startupFuture, partitionStartupContext, arg_0, arg_1));
        return startupFuture;
    }

    public ActorFuture<PartitionStartupContext> shutdown(PartitionStartupContext partitionStartupContext) {
        ActorFuture closeFuture = partitionStartupContext.getLogDeletionService().closeAsync();
        partitionStartupContext.setLogDeletionService(null);
        CompletableActorFuture shutdownFuture = new CompletableActorFuture();
        closeFuture.onComplete((arg_0, arg_1) -> LogDeletionPartitionStartupStep.lambda$shutdown$1((ActorFuture)shutdownFuture, partitionStartupContext, arg_0, arg_1));
        return shutdownFuture;
    }

    private static /* synthetic */ void lambda$shutdown$1(ActorFuture shutdownFuture, PartitionStartupContext partitionStartupContext, Void success, Throwable failure) {
        if (failure != null) {
            shutdownFuture.completeExceptionally(failure);
        } else {
            shutdownFuture.complete((Object)partitionStartupContext);
        }
    }

    private static /* synthetic */ void lambda$startup$0(ActorFuture startupFuture, PartitionStartupContext partitionStartupContext, Void success, Throwable failure) {
        if (failure != null) {
            startupFuture.completeExceptionally(failure);
        } else {
            startupFuture.complete((Object)partitionStartupContext);
        }
    }
}

