/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConfigurationEntry;
import io.camunda.zeebe.broker.system.configuration.ConfigurationUtil;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.util.unit.DataSize;

public final class DataCfg
implements ConfigurationEntry {
    public static final String DEFAULT_DIRECTORY = "data";
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private static final DataSize DEFAULT_DATA_SIZE = DataSize.ofMegabytes((long)128L);
    private static final boolean DEFAULT_DISK_USAGE_MONITORING_ENABLED = true;
    private static final double DEFAULT_DISK_USAGE_REPLICATION_WATERMARK = 0.99;
    private static final double DEFAULT_DISK_USAGE_COMMAND_WATERMARK = 0.97;
    private static final Duration DEFAULT_DISK_USAGE_MONITORING_DELAY = Duration.ofSeconds(1L);
    private static final double DISABLED_DISK_USAGE_WATERMARK = 1.0;
    private String directory = "data";
    private DataSize logSegmentSize = DEFAULT_DATA_SIZE;
    private Duration snapshotPeriod = Duration.ofMinutes(5L);
    private int logIndexDensity = 100;
    private boolean diskUsageMonitoringEnabled = true;
    private double diskUsageReplicationWatermark = 0.99;
    private double diskUsageCommandWatermark = 0.97;
    private Duration diskUsageMonitoringInterval = DEFAULT_DISK_USAGE_MONITORING_DELAY;

    @Override
    public void init(BrokerCfg globalConfig, String brokerBase) {
        this.directory = ConfigurationUtil.toAbsolutePath(this.directory, brokerBase);
        if (!this.diskUsageMonitoringEnabled) {
            LOG.info("Disk usage watermarks are disabled, setting all watermarks to {}", (Object)1.0);
            this.diskUsageReplicationWatermark = 1.0;
            this.diskUsageCommandWatermark = 1.0;
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public long getLogSegmentSizeInBytes() {
        return Optional.ofNullable(this.logSegmentSize).orElse(DEFAULT_DATA_SIZE).toBytes();
    }

    public DataSize getLogSegmentSize() {
        return this.logSegmentSize;
    }

    public void setLogSegmentSize(DataSize logSegmentSize) {
        this.logSegmentSize = logSegmentSize;
    }

    public Duration getSnapshotPeriod() {
        return this.snapshotPeriod;
    }

    public void setSnapshotPeriod(Duration snapshotPeriod) {
        this.snapshotPeriod = snapshotPeriod;
    }

    public int getLogIndexDensity() {
        return this.logIndexDensity;
    }

    public void setLogIndexDensity(int logIndexDensity) {
        this.logIndexDensity = logIndexDensity;
    }

    public boolean isDiskUsageMonitoringEnabled() {
        return this.diskUsageMonitoringEnabled;
    }

    public void setDiskUsageMonitoringEnabled(boolean diskUsageMonitoringEnabled) {
        this.diskUsageMonitoringEnabled = diskUsageMonitoringEnabled;
    }

    public double getDiskUsageCommandWatermark() {
        return this.diskUsageCommandWatermark;
    }

    public void setDiskUsageCommandWatermark(double diskUsageCommandWatermark) {
        this.diskUsageCommandWatermark = diskUsageCommandWatermark;
    }

    public long getFreeDiskSpaceCommandWatermark() {
        File directoryFile = new File(this.getDirectory());
        return Math.round((double)directoryFile.getTotalSpace() * (1.0 - this.diskUsageCommandWatermark));
    }

    public double getDiskUsageReplicationWatermark() {
        return this.diskUsageReplicationWatermark;
    }

    public void setDiskUsageReplicationWatermark(double diskUsageReplicationWatermark) {
        this.diskUsageReplicationWatermark = diskUsageReplicationWatermark;
    }

    public long getFreeDiskSpaceReplicationWatermark() {
        File directoryFile = new File(this.getDirectory());
        return Math.round((double)directoryFile.getTotalSpace() * (1.0 - this.diskUsageReplicationWatermark));
    }

    public Duration getDiskUsageMonitoringInterval() {
        return this.diskUsageMonitoringInterval;
    }

    public void setDiskUsageMonitoringInterval(Duration diskUsageMonitoringInterval) {
        this.diskUsageMonitoringInterval = diskUsageMonitoringInterval;
    }

    public String toString() {
        return "DataCfg{directory=" + this.directory + ", logSegmentSize=" + this.logSegmentSize + ", snapshotPeriod=" + this.snapshotPeriod + ", logIndexDensity=" + this.logIndexDensity + ", diskUsageMonitoringEnabled=" + this.diskUsageMonitoringEnabled + ", diskUsageReplicationWatermark=" + this.diskUsageReplicationWatermark + ", diskUsageCommandWatermark=" + this.diskUsageCommandWatermark + ", diskUsageMonitoringInterval=" + this.diskUsageMonitoringInterval + "}";
    }
}

