/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.distribution;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.camunda.zeebe.broker.partitioning.distribution.FixedDistributionMember;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class FixedPartitionDistributorBuilder {
    private final Map<PartitionId, Set<FixedDistributionMember>> partitions = new HashMap<PartitionId, Set<FixedDistributionMember>>();
    private final String partitionGroupName;

    public FixedPartitionDistributorBuilder(String partitionGroupName) {
        this.partitionGroupName = partitionGroupName;
    }

    public FixedPartitionDistributorBuilder assignMember(int partitionId, int nodeId, int priority) {
        return this.assignMember(PartitionId.from((String)this.partitionGroupName, (int)partitionId), MemberId.from((String)String.valueOf(nodeId)), priority);
    }

    public FixedPartitionDistributorBuilder assignMember(PartitionId partitionId, MemberId memberId, int priority) {
        Set members = this.partitions.computeIfAbsent(partitionId, ignored -> new HashSet());
        members.add(new FixedDistributionMember(memberId, priority));
        return this;
    }

    public FixedPartitionDistributor build() {
        return new FixedPartitionDistributor(this.partitions);
    }
}

