/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.exporter.stream.ExporterPositionsMessage;
import io.camunda.zeebe.broker.system.partitions.PartitionMessagingService;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ExporterPositionsDistributionService
implements AutoCloseable {
    private final PartitionMessagingService partitionMessagingService;
    private final String exporterPositionsTopic;
    private final BiConsumer<String, Long> exporterPositionConsumer;

    public ExporterPositionsDistributionService(BiConsumer<String, Long> exporterPositionConsumer, PartitionMessagingService partitionMessagingService, String exporterTopic) {
        this.exporterPositionConsumer = exporterPositionConsumer;
        this.partitionMessagingService = partitionMessagingService;
        this.exporterPositionsTopic = exporterTopic;
    }

    public void subscribeForExporterPositions(Executor executor) {
        this.partitionMessagingService.subscribe(this.exporterPositionsTopic, this::storeExporterPositions, executor);
    }

    private void storeExporterPositions(ByteBuffer byteBuffer) {
        UnsafeBuffer readBuffer = new UnsafeBuffer(byteBuffer);
        ExporterPositionsMessage exportPositionsMessage = new ExporterPositionsMessage();
        exportPositionsMessage.wrap((DirectBuffer)readBuffer, 0, readBuffer.capacity());
        Map<String, Long> exporterPositions = exportPositionsMessage.getExporterPositions();
        Loggers.EXPORTER_LOGGER.debug("Received new exporter state {}", exporterPositions);
        exporterPositions.forEach(this.exporterPositionConsumer);
    }

    public void distributeExporterPositions(ExporterPositionsMessage exporterPositionsMessage) {
        this.partitionMessagingService.broadcast(this.exporterPositionsTopic, exporterPositionsMessage.toByteBuffer());
    }

    @Override
    public void close() {
        this.partitionMessagingService.unsubscribe(this.exporterPositionsTopic);
    }
}

