/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.context;

import io.camunda.zeebe.exporter.api.context.Configuration;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.EnsureUtil;
import org.slf4j.Logger;

public final class ExporterContext
implements Context {
    private static final Context.RecordFilter DEFAULT_FILTER = new AcceptAllRecordsFilter();
    private final Logger logger;
    private final Configuration configuration;
    private Context.RecordFilter filter = DEFAULT_FILTER;

    public ExporterContext(Logger logger, Configuration configuration) {
        this.logger = logger;
        this.configuration = configuration;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Context.RecordFilter getFilter() {
        return this.filter;
    }

    public void setFilter(Context.RecordFilter filter) {
        EnsureUtil.ensureNotNull((String)"filter", (Object)filter);
        this.filter = filter;
    }

    private static class AcceptAllRecordsFilter
    implements Context.RecordFilter {
        private AcceptAllRecordsFilter() {
        }

        public boolean acceptType(RecordType recordType) {
            return true;
        }

        public boolean acceptValue(ValueType valueType) {
            return true;
        }
    }
}

