/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.engine.impl;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.broker.partitioning.topology.TopologyPartitionListenerImpl;
import io.camunda.zeebe.engine.processing.message.command.PartitionCommandSender;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2IntHashMap;
import org.agrona.concurrent.UnsafeBuffer;

public final class PartitionCommandSenderImpl
implements PartitionCommandSender {
    private final ClusterCommunicationService communicationService;
    private final TopologyPartitionListenerImpl partitionListener;

    public PartitionCommandSenderImpl(ClusterCommunicationService communicationService, TopologyPartitionListenerImpl partitionListener) {
        this.communicationService = communicationService;
        this.partitionListener = partitionListener;
    }

    public boolean sendCommand(int receiverPartitionId, BufferWriter command) {
        Int2IntHashMap partitionLeaders = this.partitionListener.getPartitionLeaders();
        if (!partitionLeaders.containsKey(receiverPartitionId)) {
            return true;
        }
        int partitionLeader = partitionLeaders.get(receiverPartitionId);
        byte[] bytes = new byte[command.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        command.write((MutableDirectBuffer)buffer, 0);
        this.communicationService.unicast("subscription", (Object)bytes, MemberId.from((String)("" + partitionLeader)));
        return true;
    }
}

