/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.clustering;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.AtomixClusterBuilder;
import io.atomix.cluster.ClusterConfig;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.BootstrapDiscoveryBuilder;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.SwimMembershipProtocol;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.MembershipCfg;
import io.camunda.zeebe.broker.system.configuration.NetworkCfg;
import io.camunda.zeebe.broker.system.configuration.SecurityCfg;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class AtomixClusterFactory {
    private static final Logger LOG = Loggers.CLUSTERING_LOGGER;

    private AtomixClusterFactory() {
    }

    public static AtomixCluster fromConfiguration(BrokerCfg configuration) {
        ClusterCfg clusterCfg = configuration.getCluster();
        int nodeId = clusterCfg.getNodeId();
        String localMemberId = Integer.toString(nodeId);
        NetworkCfg networkCfg = configuration.getNetwork();
        NodeDiscoveryProvider discoveryProvider = AtomixClusterFactory.createDiscoveryProvider(clusterCfg, localMemberId);
        MembershipCfg membershipCfg = clusterCfg.getMembership();
        GroupMembershipProtocol membershipProtocol = SwimMembershipProtocol.builder().withFailureTimeout(membershipCfg.getFailureTimeout()).withGossipInterval(membershipCfg.getGossipInterval()).withProbeInterval(membershipCfg.getProbeInterval()).withProbeTimeout(membershipCfg.getProbeTimeout()).withBroadcastDisputes(membershipCfg.isBroadcastDisputes()).withBroadcastUpdates(membershipCfg.isBroadcastUpdates()).withGossipFanout(membershipCfg.getGossipFanout()).withNotifySuspect(membershipCfg.isNotifySuspect()).withSuspectProbes(membershipCfg.getSuspectProbes()).withSyncInterval(membershipCfg.getSyncInterval()).build();
        AtomixClusterBuilder atomixBuilder = new AtomixClusterBuilder(new ClusterConfig()).withClusterId(clusterCfg.getClusterName()).withMemberId(localMemberId).withMembershipProtocol(membershipProtocol).withMessagingInterface(networkCfg.getInternalApi().getHost()).withMessagingPort(networkCfg.getInternalApi().getPort()).withAddress(Address.from((String)networkCfg.getInternalApi().getAdvertisedHost(), (int)networkCfg.getInternalApi().getAdvertisedPort())).withMembershipProvider(discoveryProvider);
        SecurityCfg securityCfg = networkCfg.getSecurity();
        if (securityCfg.isEnabled()) {
            atomixBuilder.withSecurity(securityCfg.getCertificateChainPath(), securityCfg.getPrivateKeyPath());
        }
        return atomixBuilder.build();
    }

    private static NodeDiscoveryProvider createDiscoveryProvider(ClusterCfg clusterCfg, String localMemberId) {
        BootstrapDiscoveryBuilder builder = BootstrapDiscoveryProvider.builder();
        List<String> initialContactPoints = clusterCfg.getInitialContactPoints();
        ArrayList nodes = new ArrayList();
        initialContactPoints.forEach(contactAddress -> {
            Node node = Node.builder().withAddress(Address.from((String)contactAddress)).build();
            LOG.debug("Member {} will contact node: {}", (Object)localMemberId, (Object)node.address());
            nodes.add(node);
        });
        return builder.withNodes(nodes).build();
    }
}

