/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.engine.impl.SubscriptionApiCommandMessageHandlerService;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;

class SubscriptionApiStep
extends AbstractBrokerStartupStep {
    SubscriptionApiStep() {
    }

    public String getName() {
        return "Subscription API";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        BrokerInfo brokerInfo = brokerStartupContext.getBrokerInfo();
        ActorSchedulingService actorSchedulingService = brokerStartupContext.getActorSchedulingService();
        ClusterServicesImpl clusterServices = brokerStartupContext.getClusterServices();
        SubscriptionApiCommandMessageHandlerService subscriptionApiService = new SubscriptionApiCommandMessageHandlerService(brokerInfo, clusterServices.getCommunicationService());
        concurrencyControl.runOnCompletion(actorSchedulingService.submitActor((Actor)subscriptionApiService), this.proceed(() -> {
            brokerStartupContext.addPartitionListener(subscriptionApiService);
            brokerStartupContext.addDiskSpaceUsageListener(subscriptionApiService);
            brokerStartupContext.setSubscriptionApiService(subscriptionApiService);
            startupFuture.complete((Object)brokerStartupContext);
        }, startupFuture));
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        SubscriptionApiCommandMessageHandlerService subscriptionApiService = brokerShutdownContext.getSubscriptionApiService();
        if (subscriptionApiService == null) {
            shutdownFuture.complete((Object)brokerShutdownContext);
            return;
        }
        concurrencyControl.runOnCompletion(subscriptionApiService.closeAsync(), this.proceed(() -> {
            brokerShutdownContext.removePartitionListener(subscriptionApiService);
            brokerShutdownContext.removeDiskSpaceUsageListener(subscriptionApiService);
            brokerShutdownContext.setSubscriptionApiService(null);
            shutdownFuture.complete((Object)brokerShutdownContext);
        }, shutdownFuture));
    }
}

