/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.partitioning.PartitionManagerImpl;
import io.camunda.zeebe.broker.system.management.BrokerAdminServiceImpl;
import io.camunda.zeebe.broker.transport.adminapi.AdminApiRequestHandler;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.concurrent.CompletableFuture;

final class PartitionManagerStep
extends AbstractBrokerStartupStep {
    PartitionManagerStep() {
    }

    public String getName() {
        return "Partition Manager";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        PartitionManagerImpl partitionManager = new PartitionManagerImpl(brokerStartupContext.getActorSchedulingService(), brokerStartupContext.getBrokerConfiguration(), brokerStartupContext.getBrokerInfo(), brokerStartupContext.getClusterServices(), brokerStartupContext.getHealthCheckService(), brokerStartupContext.getLeaderManagementRequestHandler().getPushDeploymentRequestHandler(), brokerStartupContext::addDiskSpaceUsageListener, brokerStartupContext.getPartitionListeners(), brokerStartupContext.getCommandApiService(), brokerStartupContext.getExporterRepository());
        CompletableFuture.runAsync(() -> partitionManager.start().whenComplete((ok, error) -> {
            if (error != null) {
                startupFuture.completeExceptionally(error);
                return;
            }
            this.forwardExceptions(() -> concurrencyControl.run(() -> this.forwardExceptions(() -> {
                AdminApiRequestHandler adminApi = brokerStartupContext.getAdminApiService();
                adminApi.injectPartitionManager(partitionManager);
                BrokerAdminServiceImpl adminService = brokerStartupContext.getBrokerAdminService();
                adminService.injectAdminAccess(partitionManager.createAdminAccess((ConcurrencyControl)adminService));
                adminService.injectPartitionInfoSource(partitionManager.getPartitions());
                brokerStartupContext.setPartitionManager(partitionManager);
                startupFuture.complete((Object)brokerStartupContext);
            }, startupFuture)), startupFuture);
        }));
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        PartitionManagerImpl partitionManger = brokerShutdownContext.getPartitionManager();
        if (partitionManger == null) {
            shutdownFuture.complete(null);
            return;
        }
        CompletableFuture.runAsync(() -> partitionManger.stop().whenComplete((ok, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
                return;
            }
            this.forwardExceptions(() -> concurrencyControl.run(() -> this.forwardExceptions(() -> {
                brokerShutdownContext.setPartitionManager(null);
                shutdownFuture.complete((Object)brokerShutdownContext);
            }, shutdownFuture)), shutdownFuture);
        }));
    }
}

