/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.system.management.LeaderManagementRequestHandler;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;

final class LeaderManagementRequestHandlerStep
extends AbstractBrokerStartupStep {
    LeaderManagementRequestHandlerStep() {
    }

    public String getName() {
        return "Leader Management Request Handler";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        BrokerInfo brokerInfo = brokerStartupContext.getBrokerInfo();
        ClusterServicesImpl clusterServices = brokerStartupContext.getClusterServices();
        LeaderManagementRequestHandler managementRequestHandler = new LeaderManagementRequestHandler(brokerInfo, clusterServices.getCommunicationService(), clusterServices.getEventService());
        ActorFuture actorStartFuture = brokerStartupContext.getActorSchedulingService().submitActor((Actor)managementRequestHandler);
        concurrencyControl.runOnCompletion(actorStartFuture, (ok, error) -> {
            if (error != null) {
                startupFuture.completeExceptionally(error);
                return;
            }
            this.forwardExceptions(() -> {
                brokerStartupContext.addPartitionListener(managementRequestHandler);
                brokerStartupContext.addDiskSpaceUsageListener(managementRequestHandler);
                brokerStartupContext.setLeaderManagementRequestHandler(managementRequestHandler);
                startupFuture.complete((Object)brokerStartupContext);
            }, startupFuture);
        });
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        LeaderManagementRequestHandler handler = brokerShutdownContext.getLeaderManagementRequestHandler();
        if (handler == null) {
            shutdownFuture.complete((Object)brokerShutdownContext);
            return;
        }
        ActorFuture closeFuture = handler.closeAsync();
        concurrencyControl.runOnCompletion(closeFuture, (ok, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
                return;
            }
            this.forwardExceptions(() -> {
                brokerShutdownContext.removeDiskSpaceUsageListener(handler);
                brokerShutdownContext.removePartitionListener(handler);
                brokerShutdownContext.setLeaderManagementRequestHandler(null);
                shutdownFuture.complete((Object)brokerShutdownContext);
            }, shutdownFuture);
        });
    }
}

