/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingService;
import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.BackpressureCfg;
import io.camunda.zeebe.broker.transport.backpressure.PartitionAwareRequestLimiter;
import io.camunda.zeebe.broker.transport.commandapi.CommandApiServiceImpl;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.transport.ServerTransport;
import io.camunda.zeebe.transport.impl.AtomixServerTransport;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;

final class CommandApiServiceStep
extends AbstractBrokerStartupStep {
    CommandApiServiceStep() {
    }

    public String getName() {
        return "Command API";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        concurrencyControl.run(() -> this.startServerTransport(brokerStartupContext, startupFuture));
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        CommandApiServiceImpl commandApiServiceActor = brokerShutdownContext.getCommandApiService();
        if (commandApiServiceActor == null) {
            this.closeServerTransport(brokerShutdownContext, concurrencyControl, shutdownFuture);
            return;
        }
        brokerShutdownContext.removePartitionListener(commandApiServiceActor);
        brokerShutdownContext.removeDiskSpaceUsageListener(commandApiServiceActor);
        concurrencyControl.runOnCompletion(commandApiServiceActor.closeAsync(), this.proceed(() -> {
            brokerShutdownContext.setCommandApiService(null);
            this.closeServerTransport(brokerShutdownContext, concurrencyControl, shutdownFuture);
        }, shutdownFuture));
    }

    private void startServerTransport(BrokerStartupContext brokerStartupContext, ActorFuture<BrokerStartupContext> startupFuture) {
        ConcurrencyControl concurrencyControl = brokerStartupContext.getConcurrencyControl();
        BrokerInfo brokerInfo = brokerStartupContext.getBrokerInfo();
        ActorSchedulingService schedulingService = brokerStartupContext.getActorSchedulingService();
        ManagedMessagingService messagingService = brokerStartupContext.getApiMessagingService();
        AtomixServerTransport atomixServerTransport = new AtomixServerTransport(brokerInfo.getNodeId(), (MessagingService)messagingService);
        concurrencyControl.runOnCompletion(schedulingService.submitActor((Actor)atomixServerTransport), this.proceed(() -> {
            brokerStartupContext.setCommandApiServerTransport(atomixServerTransport);
            this.startCommandApiService(brokerStartupContext, (ServerTransport)atomixServerTransport, startupFuture);
        }, startupFuture));
    }

    private void startCommandApiService(BrokerStartupContext brokerStartupContext, ServerTransport serverTransport, ActorFuture<BrokerStartupContext> startupFuture) {
        ConcurrencyControl concurrencyControl = brokerStartupContext.getConcurrencyControl();
        BrokerInfo brokerInfo = brokerStartupContext.getBrokerInfo();
        BrokerCfg brokerCfg = brokerStartupContext.getBrokerConfiguration();
        ActorSchedulingService schedulingService = brokerStartupContext.getActorSchedulingService();
        BackpressureCfg backpressureCfg = brokerCfg.getBackpressure();
        PartitionAwareRequestLimiter limiter = PartitionAwareRequestLimiter.newNoopLimiter();
        if (backpressureCfg.isEnabled()) {
            limiter = PartitionAwareRequestLimiter.newLimiter(backpressureCfg);
        }
        CommandApiServiceImpl commandApiService = new CommandApiServiceImpl(serverTransport, brokerInfo, limiter, schedulingService, brokerCfg.getExperimental().getQueryApi());
        concurrencyControl.runOnCompletion(schedulingService.submitActor((Actor)commandApiService), this.proceed(() -> {
            brokerStartupContext.setCommandApiService(commandApiService);
            brokerStartupContext.addPartitionListener(commandApiService);
            brokerStartupContext.addDiskSpaceUsageListener(commandApiService);
            startupFuture.complete((Object)brokerStartupContext);
        }, startupFuture));
    }

    private void closeServerTransport(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        AtomixServerTransport serverTransport = brokerShutdownContext.getCommandApiServerTransport();
        if (serverTransport == null) {
            return;
        }
        concurrencyControl.runOnCompletion(serverTransport.closeAsync(), this.proceed(() -> {
            brokerShutdownContext.setCommandApiServerTransport(null);
            shutdownFuture.complete((Object)brokerShutdownContext);
        }, shutdownFuture));
    }
}

