/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file;

import com.google.common.base.Preconditions;
import io.camunda.zeebe.journal.file.JournalSegmentDescriptor;
import io.camunda.zeebe.journal.file.SegmentedJournal;
import io.camunda.zeebe.journal.file.SparseJournalIndex;
import java.io.File;

public class SegmentedJournalBuilder {
    private static final String DEFAULT_NAME = "journal";
    private static final String DEFAULT_DIRECTORY = System.getProperty("user.dir");
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
    private static final long DEFAULT_MIN_FREE_DISK_SPACE = 0x40000000L;
    private static final int DEFAULT_JOURNAL_INDEX_DENSITY = 100;
    protected String name = "journal";
    protected File directory = new File(DEFAULT_DIRECTORY);
    protected int maxSegmentSize = 0x2000000;
    private long freeDiskSpace = 0x40000000L;
    private int journalIndexDensity = 100;
    private long lastWrittenIndex = -1L;

    protected SegmentedJournalBuilder() {
    }

    public SegmentedJournalBuilder withName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        return this;
    }

    public SegmentedJournalBuilder withDirectory(String directory) {
        return this.withDirectory(new File((String)Preconditions.checkNotNull((Object)directory, (Object)"directory cannot be null")));
    }

    public SegmentedJournalBuilder withDirectory(File directory) {
        this.directory = (File)Preconditions.checkNotNull((Object)directory, (Object)"directory cannot be null");
        return this;
    }

    public SegmentedJournalBuilder withMaxSegmentSize(int maxSegmentSize) {
        Preconditions.checkArgument((maxSegmentSize > JournalSegmentDescriptor.getEncodingLength() ? 1 : 0) != 0, (Object)("maxSegmentSize must be greater than " + JournalSegmentDescriptor.getEncodingLength()));
        this.maxSegmentSize = maxSegmentSize;
        return this;
    }

    public SegmentedJournalBuilder withFreeDiskSpace(long freeDiskSpace) {
        Preconditions.checkArgument((freeDiskSpace >= 0L ? 1 : 0) != 0, (Object)"minFreeDiskSpace must be positive");
        this.freeDiskSpace = freeDiskSpace;
        return this;
    }

    public SegmentedJournalBuilder withJournalIndexDensity(int journalIndexDensity) {
        this.journalIndexDensity = journalIndexDensity;
        return this;
    }

    public SegmentedJournalBuilder withLastWrittenIndex(long lastWrittenIndex) {
        this.lastWrittenIndex = lastWrittenIndex;
        return this;
    }

    public SegmentedJournal build() {
        SparseJournalIndex journalIndex = new SparseJournalIndex(this.journalIndexDensity);
        return new SegmentedJournal(this.name, this.directory, this.maxSegmentSize, this.freeDiskSpace, journalIndex, this.lastWrittenIndex);
    }
}

