/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.ActorTask;
import org.agrona.UnsafeAccess;

class ActorTaskQueueNode {
    protected static final long PREV_OFFSET;
    protected static final long NEXT_OFFSET;
    volatile ActorTaskQueueNode next;
    volatile ActorTaskQueueNode prev;
    long stateCount;
    ActorTask task;

    ActorTaskQueueNode() {
    }

    void nextOrdered(ActorTaskQueueNode t) {
        assert (t != this);
        UnsafeAccess.UNSAFE.putOrderedObject(this, NEXT_OFFSET, t);
    }

    void prevOrdered(ActorTaskQueueNode t) {
        assert (t != this);
        UnsafeAccess.UNSAFE.putObjectVolatile(this, PREV_OFFSET, t);
    }

    public void setTask(ActorTask task) {
        this.task = task;
    }

    static {
        try {
            PREV_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ActorTaskQueueNode.class.getDeclaredField("prev"));
            NEXT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ActorTaskQueueNode.class.getDeclaredField("next"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

