/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.ActorCondition;
import io.camunda.zeebe.util.sched.ActorJob;
import io.camunda.zeebe.util.sched.ActorSubscription;
import io.camunda.zeebe.util.sched.ActorTask;
import java.util.concurrent.atomic.AtomicLong;

public final class ActorConditionImpl
implements ActorCondition,
ActorSubscription {
    private final ActorJob job;
    private final String conditionName;
    private final ActorTask task;
    private final AtomicLong triggerCount;
    private long runCount = 0L;

    public ActorConditionImpl(String conditionName, ActorJob job) {
        this.conditionName = conditionName;
        this.job = job;
        this.task = job.getTask();
        this.triggerCount = new AtomicLong(0L);
    }

    @Override
    public void signal() {
        this.triggerCount.getAndIncrement();
        this.task.tryWakeup();
    }

    @Override
    public void cancel() {
        this.task.onSubscriptionCancelled(this);
    }

    @Override
    public boolean poll() {
        return this.triggerCount.get() > this.runCount;
    }

    @Override
    public ActorJob getJob() {
        return this.job;
    }

    @Override
    public boolean isRecurring() {
        return true;
    }

    @Override
    public void onJobCompleted() {
        ++this.runCount;
    }

    public String toString() {
        return "Condition " + this.conditionName;
    }
}

