/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.health;

import io.camunda.zeebe.util.health.HealthReport;

public final class HealthIssue {
    private final String message;
    private final Throwable throwable;
    private final HealthReport cause;

    private HealthIssue(String message, Throwable throwable, HealthReport cause) {
        this.message = message;
        this.throwable = throwable;
        this.cause = cause;
    }

    public static HealthIssue of(String message) {
        return new HealthIssue(message, null, null);
    }

    public static HealthIssue of(Throwable throwable) {
        return new HealthIssue(null, throwable, null);
    }

    public static HealthIssue of(HealthReport cause) {
        return new HealthIssue(null, null, cause);
    }

    public String toString() {
        if (this.cause != null) {
            return this.cause.toString();
        }
        if (this.message != null) {
            return "'" + this.message + "'";
        }
        if (this.throwable != null) {
            return this.throwable.toString();
        }
        return "unknown";
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public HealthReport getCause() {
        return this.cause;
    }
}

