/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.collection;

import io.camunda.zeebe.util.collection.Reusable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public final class ReusableObjectList<T extends Reusable>
implements Iterable<T> {
    private final ObjectIterator iterator = new ObjectIterator();
    private final List<ReusableElement> elements = new ArrayList<ReusableElement>();
    private final Supplier<T> elementFactory;
    private int size = 0;

    public ReusableObjectList(Supplier<T> elementFactory) {
        this.elementFactory = elementFactory;
    }

    public T add() {
        for (int i = 0; i < this.elements.size(); ++i) {
            ReusableElement element = this.elements.get(i);
            if (element.isSet()) continue;
            element.set(true);
            ++this.size;
            return element.getElement();
        }
        Reusable newElement = (Reusable)this.elementFactory.get();
        this.elements.add(new ReusableElement(this, newElement));
        ++this.size;
        return (T)newElement;
    }

    public void remove(T element) {
        for (int i = 0; i < this.elements.size(); ++i) {
            ReusableElement e = this.elements.get(i);
            if (e.getElement() != element) continue;
            e.getElement().reset();
            e.set(false);
            --this.size;
        }
    }

    public T poll() {
        for (int i = 0; i < this.elements.size(); ++i) {
            ReusableElement element = this.elements.get(i);
            if (!element.isSet()) continue;
            element.set(false);
            --this.size;
            return element.getElement();
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        for (ReusableElement element : this.elements) {
            element.getElement().reset();
            element.set(false);
        }
        this.size = 0;
    }

    @Override
    public Iterator<T> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    private class ObjectIterator
    implements Iterator<T> {
        private ReusableElement current = null;
        private int index = 0;

        private ObjectIterator() {
        }

        public void reset() {
            this.index = 0;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.index; i < ReusableObjectList.this.elements.size(); ++i) {
                ReusableElement element = ReusableObjectList.this.elements.get(i);
                if (!element.isSet()) continue;
                this.index = i;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                this.current = ReusableObjectList.this.elements.get(this.index);
                ++this.index;
                return this.current.getElement();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.getElement().reset();
            this.current.set(false);
            --ReusableObjectList.this.size;
        }
    }

    private static class ReusableElement {
        private final T element;
        private boolean isSet = true;
        final /* synthetic */ ReusableObjectList this$0;

        ReusableElement(T element) {
            this.this$0 = var1_1;
            this.element = element;
        }

        public boolean isSet() {
            return this.isSet;
        }

        public void set(boolean isSet) {
            this.isSet = isSet;
        }

        public T getElement() {
            return this.element;
        }
    }
}

