/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.SerializerFactory;
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import com.esotericsoftware.kryo.util.Pool;
import io.atomix.utils.serializer.Namespace;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatibleKryoPool
extends Pool<Kryo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompatibleKryoPool.class);
    private final String friendlyName;
    private final ClassLoader classLoader;
    private final List<Namespace.RegistrationBlock> registeredBlocks;

    public CompatibleKryoPool(String friendlyName, ClassLoader classLoader, List<Namespace.RegistrationBlock> registeredBlocks) {
        super(true, true);
        this.friendlyName = friendlyName;
        this.classLoader = classLoader;
        this.registeredBlocks = registeredBlocks;
    }

    protected Kryo create() {
        Kryo kryo = new Kryo();
        CompatibleFieldSerializer.CompatibleFieldSerializerConfig serializerConfig = new CompatibleFieldSerializer.CompatibleFieldSerializerConfig();
        serializerConfig.setChunkedEncoding(true);
        serializerConfig.setReadUnknownFieldData(false);
        kryo.setDefaultSerializer((SerializerFactory)new SerializerFactory.CompatibleFieldSerializerFactory(serializerConfig));
        kryo.setRegistrationRequired(true);
        kryo.setClassLoader(this.classLoader);
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        for (Namespace.RegistrationBlock block : this.registeredBlocks) {
            int id = block.begin();
            if (id == -1) {
                id = kryo.getNextRegistrationId();
            }
            for (Pair entry : block.types()) {
                this.register(kryo, (Class[])entry.getLeft(), (Serializer)entry.getRight(), id++);
            }
        }
        kryo.reset();
        return kryo;
    }

    private void register(Kryo kryo, Class<?>[] types, Serializer<?> serializer, int id) {
        Registration existing = kryo.getRegistration(id);
        if (existing != null && !this.contains(types, existing)) {
            LOGGER.error("{}: Failed to register {} as {}. {} was already registered with that id.", new Object[]{this.friendlyName, types, id, existing.getType()});
            throw new IllegalStateException(String.format("Failed to register %s as %s, %s was already registered.", Arrays.toString(types), id, existing.getType()));
        }
        for (Class<?> type : types) {
            Registration r = null;
            if (serializer == null) {
                r = kryo.register(type, id);
            } else if (type.isInterface()) {
                kryo.addDefaultSerializer(type, serializer);
            } else {
                r = kryo.register(type, serializer, id);
            }
            if (r == null || r.getId() == id) continue;
            LOGGER.trace("Skipping {}: {} already registered as {}.", new Object[]{r.getType(), r.getId(), id});
        }
    }

    private boolean contains(Class<?>[] types, Registration existing) {
        boolean matches = false;
        for (Class<?> type : types) {
            if (existing.getType() != type) continue;
            matches = true;
            break;
        }
        return matches;
    }
}

