/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.misc;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class TimestampPrinter {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss,SSS");
    private final long timestamp;

    public TimestampPrinter(long timestamp) {
        this.timestamp = timestamp;
    }

    public static TimestampPrinter of(long timestamp) {
        return new TimestampPrinter(timestamp);
    }

    public String toString() {
        return FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZoneId.systemDefault()));
    }
}

