/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.logging;

import io.atomix.utils.logging.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class ContextualLogger
implements Logger {
    private static final String SEPARATOR = " - ";
    private final LoggerContext context;
    private final Logger delegate;

    public ContextualLogger(Logger delegate, LoggerContext context) {
        this.delegate = delegate;
        this.context = context;
    }

    private String contextualize(String msg) {
        return this.context + SEPARATOR + msg;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(this.contextualize(msg));
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(this.contextualize(format), arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(this.contextualize(format), arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(this.contextualize(format), arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(this.contextualize(msg), t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegate.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(marker, this.contextualize(msg));
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(marker, this.contextualize(format), arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(marker, this.contextualize(format), arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(marker, this.contextualize(format), argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.delegate.trace(marker, this.contextualize(msg), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(this.contextualize(msg));
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(this.contextualize(format), arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(this.contextualize(format), arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(this.contextualize(format), arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(this.contextualize(msg), t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegate.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(marker, this.contextualize(msg));
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(marker, this.contextualize(format), arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(marker, this.contextualize(format), arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(marker, this.contextualize(format), arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.delegate.debug(marker, this.contextualize(msg), t);
        }
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.delegate.info(this.contextualize(msg));
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.delegate.info(this.contextualize(format), arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.delegate.info(this.contextualize(format), arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.delegate.info(this.contextualize(format), arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.delegate.info(this.contextualize(msg), t);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegate.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled()) {
            this.delegate.info(marker, this.contextualize(msg));
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.delegate.info(marker, this.contextualize(format), arg);
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.delegate.info(marker, this.contextualize(format), arg1, arg2);
        }
    }

    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.delegate.info(marker, this.contextualize(format), arguments);
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.delegate.info(marker, this.contextualize(msg), t);
        }
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.delegate.warn(this.contextualize(msg));
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.delegate.warn(this.contextualize(format), arg);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.delegate.warn(this.contextualize(format), arguments);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.delegate.warn(this.contextualize(format), arg1, arg2);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.delegate.warn(this.contextualize(msg), t);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled()) {
            this.delegate.warn(marker, this.contextualize(msg));
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.delegate.warn(marker, this.contextualize(format), arg);
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.delegate.warn(marker, this.contextualize(format), arg1, arg2);
        }
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.delegate.warn(marker, this.contextualize(format), arguments);
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.delegate.warn(marker, this.contextualize(msg), t);
        }
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.delegate.error(this.contextualize(msg));
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.delegate.error(this.contextualize(format), arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.delegate.error(this.contextualize(format), arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.delegate.error(this.contextualize(format), arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.delegate.error(this.contextualize(msg), t);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegate.isWarnEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled()) {
            this.delegate.error(marker, this.contextualize(msg));
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.delegate.error(marker, this.contextualize(format), arg);
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.delegate.error(marker, this.contextualize(format), arg1, arg2);
        }
    }

    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.delegate.error(marker, this.contextualize(format), arguments);
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.delegate.error(marker, this.contextualize(msg), t);
        }
    }
}

