/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.impl.SfvChecksum;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class SnapshotChecksum {
    private SnapshotChecksum() {
        throw new IllegalStateException("Utility class");
    }

    public static SfvChecksum read(Path checksumPath) throws IOException {
        try (RandomAccessFile checksumFile = new RandomAccessFile(checksumPath.toFile(), "r");){
            String line;
            if (checksumFile.length() == 8L) {
                long combinedChecksum = checksumFile.readLong();
                SfvChecksum sfvChecksum = new SfvChecksum(combinedChecksum);
                return sfvChecksum;
            }
            SfvChecksum sfvChecksum = new SfvChecksum();
            while ((line = checksumFile.readLine()) != null) {
                sfvChecksum.updateFromSfvFile(line);
            }
            SfvChecksum sfvChecksum2 = sfvChecksum;
            return sfvChecksum2;
        }
    }

    public static SfvChecksum calculate(Path snapshotDirectory) throws IOException {
        try (Stream<Path> fileStream = Files.list(snapshotDirectory).sorted();){
            SfvChecksum sfvChecksum = SnapshotChecksum.createCombinedChecksum(fileStream.collect(Collectors.toList()));
            sfvChecksum.setSnapshotDirectoryComment(snapshotDirectory.toString());
            SfvChecksum sfvChecksum2 = sfvChecksum;
            return sfvChecksum2;
        }
    }

    public static void persist(Path checksumPath, SfvChecksum checksum) throws IOException {
        try (RandomAccessFile checksumFile = new RandomAccessFile(checksumPath.toFile(), "rwd");){
            byte[] data = checksum.serializeSfvFileData();
            checksumFile.write(data);
            checksumFile.setLength(data.length);
        }
    }

    private static SfvChecksum createCombinedChecksum(List<Path> files) throws IOException {
        SfvChecksum checksum = new SfvChecksum();
        for (Path f : files) {
            checksum.updateFromFile(f);
        }
        return checksum;
    }
}

