/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.response.PartitionBrokerHealth;
import io.camunda.zeebe.client.api.response.PartitionBrokerRole;
import io.camunda.zeebe.client.api.response.PartitionInfo;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Arrays;

public class PartitionInfoImpl
implements PartitionInfo {
    private final int partitionId;
    private final PartitionBrokerRole role;
    private final PartitionBrokerHealth partitionBrokerHealth;

    public PartitionInfoImpl(GatewayOuterClass.Partition partition) {
        this.partitionId = partition.getPartitionId();
        if (partition.getRole() == GatewayOuterClass.Partition.PartitionBrokerRole.LEADER) {
            this.role = PartitionBrokerRole.LEADER;
        } else if (partition.getRole() == GatewayOuterClass.Partition.PartitionBrokerRole.FOLLOWER) {
            this.role = PartitionBrokerRole.FOLLOWER;
        } else if (partition.getRole() == GatewayOuterClass.Partition.PartitionBrokerRole.INACTIVE) {
            this.role = PartitionBrokerRole.INACTIVE;
        } else {
            throw new RuntimeException(String.format("Unexpected partition broker role %s, should be one of %s", partition.getRole(), Arrays.toString((Object[])PartitionBrokerRole.values())));
        }
        if (partition.getHealth() == GatewayOuterClass.Partition.PartitionBrokerHealth.HEALTHY) {
            this.partitionBrokerHealth = PartitionBrokerHealth.HEALTHY;
        } else if (partition.getHealth() == GatewayOuterClass.Partition.PartitionBrokerHealth.UNHEALTHY) {
            this.partitionBrokerHealth = PartitionBrokerHealth.UNHEALTHY;
        } else {
            throw new RuntimeException(String.format("Unexpected partition broker health %s, should be one of %s", partition.getHealth(), Arrays.toString((Object[])PartitionBrokerHealth.values())));
        }
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public PartitionBrokerRole getRole() {
        return this.role;
    }

    @Override
    public boolean isLeader() {
        return this.role == PartitionBrokerRole.LEADER;
    }

    @Override
    public PartitionBrokerHealth getHealth() {
        return this.partitionBrokerHealth;
    }

    public String toString() {
        return "PartitionInfoImpl{partitionId=" + this.partitionId + ", role=" + (Object)((Object)this.role) + ", health=" + (Object)((Object)this.partitionBrokerHealth) + '}';
    }
}

