/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import java.time.Clock;
import me.dinowernli.grpc.prometheus.ClientMetrics;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;
import me.dinowernli.grpc.prometheus.MonitoringClientCallListener;

class MonitoringClientCall<R, S>
extends ForwardingClientCall.SimpleForwardingClientCall<R, S> {
    private final ClientMetrics clientMetrics;
    private final GrpcMethod grpcMethod;
    private final Configuration configuration;
    private final Clock clock;
    private Metadata requestMetadata;

    MonitoringClientCall(ClientCall<R, S> delegate, ClientMetrics clientMetrics, GrpcMethod grpcMethod, Configuration configuration, Clock clock) {
        super(delegate);
        this.clientMetrics = clientMetrics;
        this.grpcMethod = grpcMethod;
        this.configuration = configuration;
        this.clock = clock;
    }

    public void start(ClientCall.Listener<S> delegate, Metadata metadata) {
        this.requestMetadata = metadata;
        this.clientMetrics.recordCallStarted(metadata);
        super.start(new MonitoringClientCallListener<S>(delegate, this.clientMetrics, this.grpcMethod, this.configuration, this.clock, metadata), metadata);
    }

    public void sendMessage(R requestMessage) {
        if (this.grpcMethod.streamsRequests()) {
            this.clientMetrics.recordStreamMessageSent(this.requestMetadata == null ? new Metadata() : this.requestMetadata);
        }
        super.sendMessage(requestMessage);
    }
}

