/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.Metadata;
import io.grpc.Status;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;
import me.dinowernli.grpc.prometheus.Labels;

class ClientMetrics {
    private static final List<String> defaultRequestLabels = Arrays.asList("grpc_type", "grpc_service", "grpc_method");
    private static final List<String> defaultResponseLabels = Arrays.asList("grpc_type", "grpc_service", "grpc_method", "code", "grpc_code");
    private static final Counter.Builder rpcStartedBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("client")).name("started")).help("Total number of RPCs started on the client.");
    private static final Counter.Builder rpcCompletedBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("client")).name("completed")).help("Total number of RPCs completed on the client, regardless of success or failure.");
    private static final Histogram.Builder completedLatencySecondsBuilder = (Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("grpc")).subsystem("client")).name("completed_latency_seconds")).help("Histogram of rpc response latency (in seconds) for completed rpcs.");
    private static final Counter.Builder streamMessagesReceivedBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("client")).name("msg_received")).help("Total number of stream messages received from the server.");
    private static final Counter.Builder streamMessagesSentBuilder = (Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("grpc")).subsystem("client")).name("msg_sent")).help("Total number of stream messages sent by the client.");
    private final List<Metadata.Key<String>> labelHeaderKeys;
    private final Counter rpcStarted;
    private final Counter rpcCompleted;
    private final Counter streamMessagesReceived;
    private final Counter streamMessagesSent;
    private final Optional<Histogram> completedLatencySeconds;
    private final GrpcMethod method;

    private ClientMetrics(List<Metadata.Key<String>> labelHeaderKeys, GrpcMethod method, Counter rpcStarted, Counter rpcCompleted, Counter streamMessagesReceived, Counter streamMessagesSent, Optional<Histogram> completedLatencySeconds) {
        this.labelHeaderKeys = labelHeaderKeys;
        this.method = method;
        this.rpcStarted = rpcStarted;
        this.rpcCompleted = rpcCompleted;
        this.streamMessagesReceived = streamMessagesReceived;
        this.streamMessagesSent = streamMessagesSent;
        this.completedLatencySeconds = completedLatencySeconds;
    }

    public void recordCallStarted(Metadata metadata) {
        ((Counter.Child)Labels.addLabels(this.rpcStarted, Labels.customLabels(metadata, this.labelHeaderKeys), this.method)).inc();
    }

    public void recordClientHandled(Status.Code code, Metadata metadata) {
        ArrayList<String> allLabels = new ArrayList<String>();
        allLabels.add(code.toString());
        allLabels.add(code.toString());
        allLabels.addAll(Labels.customLabels(metadata, this.labelHeaderKeys));
        ((Counter.Child)Labels.addLabels(this.rpcCompleted, allLabels, this.method)).inc();
    }

    public void recordStreamMessageSent(Metadata metadata) {
        ((Counter.Child)Labels.addLabels(this.streamMessagesSent, Labels.customLabels(metadata, this.labelHeaderKeys), this.method)).inc();
    }

    public void recordStreamMessageReceived(Metadata metadata) {
        ((Counter.Child)Labels.addLabels(this.streamMessagesReceived, Labels.customLabels(metadata, this.labelHeaderKeys), this.method)).inc();
    }

    public void recordLatency(double latencySec, Metadata metadata) {
        if (!this.completedLatencySeconds.isPresent()) {
            return;
        }
        ((Histogram.Child)Labels.addLabels((SimpleCollector)this.completedLatencySeconds.get(), Labels.customLabels(metadata, this.labelHeaderKeys), this.method)).observe(latencySec);
    }

    static class Factory {
        private final List<Metadata.Key<String>> labelHeaderKeys;
        private final Counter rpcStarted;
        private final Counter rpcCompleted;
        private final Counter streamMessagesReceived;
        private final Counter streamMessagesSent;
        private final Optional<Histogram> completedLatencySeconds;

        Factory(Configuration configuration) {
            CollectorRegistry registry = configuration.getCollectorRegistry();
            this.labelHeaderKeys = Labels.metadataKeys(configuration.getLabelHeaders());
            this.rpcStarted = (Counter)((Counter.Builder)rpcStartedBuilder.labelNames(Labels.asArray(defaultRequestLabels, configuration.getSanitizedLabelHeaders()))).register(registry);
            this.rpcCompleted = (Counter)((Counter.Builder)rpcCompletedBuilder.labelNames(Labels.asArray(defaultResponseLabels, configuration.getSanitizedLabelHeaders()))).register(registry);
            this.streamMessagesReceived = (Counter)((Counter.Builder)streamMessagesReceivedBuilder.labelNames(Labels.asArray(defaultRequestLabels, configuration.getSanitizedLabelHeaders()))).register(registry);
            this.streamMessagesSent = (Counter)((Counter.Builder)streamMessagesSentBuilder.labelNames(Labels.asArray(defaultRequestLabels, configuration.getSanitizedLabelHeaders()))).register(registry);
            this.completedLatencySeconds = configuration.isIncludeLatencyHistograms() ? Optional.of((Histogram)((Histogram.Builder)completedLatencySecondsBuilder.buckets(configuration.getLatencyBuckets()).labelNames(Labels.asArray(defaultRequestLabels, configuration.getSanitizedLabelHeaders()))).register(registry)) : Optional.empty();
        }

        ClientMetrics createMetricsForMethod(GrpcMethod grpcMethod) {
            return new ClientMetrics(this.labelHeaderKeys, grpcMethod, this.rpcStarted, this.rpcCompleted, this.streamMessagesReceived, this.streamMessagesSent, this.completedLatencySeconds);
        }
    }
}

