/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.ActorTask;
import io.camunda.zeebe.util.sched.ActorTaskQueue;
import io.camunda.zeebe.util.sched.ActorThread;
import java.util.concurrent.ThreadLocalRandom;

public final class WorkStealingGroup {
    private final int numOfThreads;
    private final ActorTaskQueue[] taskQueues;

    public WorkStealingGroup(int numOfThreads) {
        this.numOfThreads = numOfThreads;
        this.taskQueues = new ActorTaskQueue[numOfThreads];
        for (int i = 0; i < numOfThreads; ++i) {
            this.taskQueues[i] = new ActorTaskQueue();
        }
    }

    public void submit(ActorTask task, int threadId) {
        task.schedulingState.set(ActorTask.TaskSchedulingState.QUEUED);
        this.taskQueues[threadId].append(task);
    }

    protected ActorTask getNextTask() {
        ActorThread currentThread = ActorThread.current();
        ActorTask nextTask = this.taskQueues[currentThread.getRunnerId()].pop();
        if (nextTask == null) {
            nextTask = this.trySteal(currentThread);
        }
        return nextTask;
    }

    private ActorTask trySteal(ActorThread currentThread) {
        int offset;
        for (int i = offset = ThreadLocalRandom.current().nextInt(this.numOfThreads); i < offset + this.numOfThreads; ++i) {
            ActorTask stolenActor;
            int runnerId = i % this.numOfThreads;
            if (runnerId == currentThread.getRunnerId() || (stolenActor = this.taskQueues[runnerId].trySteal()) == null) continue;
            return stolenActor;
        }
        return null;
    }
}

