/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.ActorTask;
import io.camunda.zeebe.util.sched.TaskScheduler;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;

public final class PriorityScheduler
implements TaskScheduler {
    private static final int TIME_SLICES_PER_SECOND = 100;
    private static final long TIME_SLICE_LENTH_NS = TimeUnit.MILLISECONDS.toNanos(10L);
    private final IntFunction<ActorTask> getTaskFn;
    private final Run currentRun;
    private final int priorityCount;
    private final int[] slicePriorities;

    public PriorityScheduler(IntFunction<ActorTask> getTaskFn, double[] quotas) {
        this.getTaskFn = getTaskFn;
        this.priorityCount = quotas.length;
        this.slicePriorities = PriorityScheduler.calclateSlicePriorities(quotas);
        this.currentRun = new Run();
    }

    private static int[] calclateSlicePriorities(double[] quotas) {
        int i;
        int[] slicePriorities = new int[100];
        int[] sliceBudgetByPriority = new int[quotas.length];
        for (i = 0; i < sliceBudgetByPriority.length; ++i) {
            sliceBudgetByPriority[i] = (int)(100.0 * quotas[i]);
        }
        block1: for (i = 0; i < slicePriorities.length; ++i) {
            int p;
            int assignedPriority = 0;
            for (p = 0; p < quotas.length; ++p) {
                int budget;
                int q;
                if (sliceBudgetByPriority[p] <= 0 || i / (q = 100 / (budget = (int)(100.0 * quotas[p]))) <= budget - sliceBudgetByPriority[p]) continue;
                assignedPriority = p;
                break;
            }
            for (p = assignedPriority; p < assignedPriority + quotas.length; ++p) {
                int offset = p % quotas.length;
                if (sliceBudgetByPriority[offset] <= 0) continue;
                int n = offset;
                sliceBudgetByPriority[n] = sliceBudgetByPriority[n] - 1;
                slicePriorities[i] = offset;
                continue block1;
            }
        }
        return slicePriorities;
    }

    @Override
    public ActorTask getNextTask(ActorClock clock) {
        int priority = this.currentRun.getTimeSlicePriority(clock.getNanoTime());
        ActorTask nextTask = null;
        for (int p = priority; nextTask == null && p > priority - this.priorityCount; --p) {
            int priorityClass = p >= 0 ? p : Math.floorMod(p, this.priorityCount);
            nextTask = this.getTaskFn.apply(priorityClass);
        }
        return nextTask;
    }

    class Run {
        long startNs = 0L;
        long sliceId = 0L;

        Run() {
        }

        int getTimeSlicePriority(long now) {
            this.sliceId = (now - this.startNs) / TIME_SLICE_LENTH_NS;
            if (this.sliceId >= 100L) {
                this.startNs = now;
                this.sliceId %= 100L;
            }
            return PriorityScheduler.this.slicePriorities[(int)this.sliceId];
        }
    }
}

